/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;

public final class ModuleResourceLoader
implements ResourceLoader {
    private final Module module;

    public ModuleResourceLoader(Module module) {
        this.module = module;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        InputStream stream = this.module.getResourceAsStream(resource);
        if (stream == null) {
            throw new IOException("Resource not found: " + resource);
        }
        return stream;
    }

    @Override
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        try {
            Class<?> clazz = Class.forName(this.module, cname);
            if (clazz == null) {
                throw new ClassNotFoundException(cname);
            }
            return clazz.asSubclass(expectedType);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class: " + cname, e);
        }
    }
}

