/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.format;

import com.dataiku.dss.shadelib.org.apache.parquet.format.BsonType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.DateType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.DecimalType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.EnumType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.Float16Type;
import com.dataiku.dss.shadelib.org.apache.parquet.format.IntType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.JsonType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.ListType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.LogicalType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.MapType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.MicroSeconds;
import com.dataiku.dss.shadelib.org.apache.parquet.format.MilliSeconds;
import com.dataiku.dss.shadelib.org.apache.parquet.format.NullType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.StringType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.TimeType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.TimeUnit;
import com.dataiku.dss.shadelib.org.apache.parquet.format.TimestampType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.UUIDType;
import com.dataiku.dss.shadelib.org.apache.parquet.format.VariantType;

public class LogicalTypes {
    public static final LogicalType UTF8 = LogicalType.STRING(new StringType());
    public static final LogicalType MAP = LogicalType.MAP(new MapType());
    public static final LogicalType LIST = LogicalType.LIST(new ListType());
    public static final LogicalType ENUM = LogicalType.ENUM(new EnumType());
    public static final LogicalType DATE = LogicalType.DATE(new DateType());
    public static final LogicalType TIME_MILLIS = LogicalType.TIME(new TimeType(true, TimeUnits.MILLIS));
    public static final LogicalType TIME_MICROS = LogicalType.TIME(new TimeType(true, TimeUnits.MICROS));
    public static final LogicalType TIMESTAMP_MILLIS = LogicalType.TIMESTAMP(new TimestampType(true, TimeUnits.MILLIS));
    public static final LogicalType TIMESTAMP_MICROS = LogicalType.TIMESTAMP(new TimestampType(true, TimeUnits.MICROS));
    public static final LogicalType INT_8 = LogicalType.INTEGER(new IntType(8, true));
    public static final LogicalType INT_16 = LogicalType.INTEGER(new IntType(16, true));
    public static final LogicalType INT_32 = LogicalType.INTEGER(new IntType(32, true));
    public static final LogicalType INT_64 = LogicalType.INTEGER(new IntType(64, true));
    public static final LogicalType UINT_8 = LogicalType.INTEGER(new IntType(8, false));
    public static final LogicalType UINT_16 = LogicalType.INTEGER(new IntType(16, false));
    public static final LogicalType UINT_32 = LogicalType.INTEGER(new IntType(32, false));
    public static final LogicalType UINT_64 = LogicalType.INTEGER(new IntType(64, false));
    public static final LogicalType UNKNOWN = LogicalType.UNKNOWN(new NullType());
    public static final LogicalType JSON = LogicalType.JSON(new JsonType());
    public static final LogicalType BSON = LogicalType.BSON(new BsonType());
    public static final LogicalType FLOAT16 = LogicalType.FLOAT16(new Float16Type());
    public static final LogicalType UUID = LogicalType.UUID(new UUIDType());

    public static LogicalType DECIMAL(int scale, int precision) {
        return LogicalType.DECIMAL(new DecimalType(scale, precision));
    }

    public static LogicalType VARIANT(byte specificationVersion) {
        VariantType type = new VariantType();
        type.setSpecification_version(specificationVersion);
        return LogicalType.VARIANT(type);
    }

    public static class TimeUnits {
        public static final TimeUnit MILLIS = TimeUnit.MILLIS(new MilliSeconds());
        public static final TimeUnit MICROS = TimeUnit.MICROS(new MicroSeconds());
    }
}

