/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop;

import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.ParquetFileReader;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.BlockMetaData;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.metadata.ColumnPath;
import com.dataiku.dss.shadelib.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import com.dataiku.dss.shadelib.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import com.dataiku.dss.shadelib.org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnIndexStoreImpl
implements ColumnIndexStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnIndexStoreImpl.class);
    private static final IndexStore MISSING_INDEX_STORE = new IndexStore(){

        @Override
        public ColumnIndex getColumnIndex() {
            return null;
        }

        @Override
        public OffsetIndex getOffsetIndex() {
            return null;
        }
    };
    private static final ColumnIndexStoreImpl EMPTY = new ColumnIndexStoreImpl(null, new BlockMetaData(), Collections.emptySet()){

        @Override
        public ColumnIndex getColumnIndex(ColumnPath column) {
            return null;
        }

        @Override
        public OffsetIndex getOffsetIndex(ColumnPath column) {
            throw new ColumnIndexStore.MissingOffsetIndexException(column);
        }
    };
    private final ParquetFileReader reader;
    private final Map<ColumnPath, IndexStore> store;

    static ColumnIndexStore create(ParquetFileReader reader, BlockMetaData block, Set<ColumnPath> paths) {
        try {
            return new ColumnIndexStoreImpl(reader, block, paths);
        }
        catch (ColumnIndexStore.MissingOffsetIndexException e) {
            return EMPTY;
        }
    }

    private ColumnIndexStoreImpl(ParquetFileReader reader, BlockMetaData block, Set<ColumnPath> paths) {
        this.reader = reader;
        HashMap<ColumnPath, IndexStore> store = new HashMap<ColumnPath, IndexStore>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            ColumnPath path = column.getPath();
            if (!paths.contains(path)) continue;
            store.put(path, new IndexStoreImpl(column));
        }
        this.store = store;
    }

    @Override
    public ColumnIndex getColumnIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getColumnIndex();
    }

    @Override
    public OffsetIndex getOffsetIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getOffsetIndex();
    }

    private class IndexStoreImpl
    implements IndexStore {
        private final ColumnChunkMetaData meta;
        private ColumnIndex columnIndex;
        private boolean columnIndexRead;
        private final OffsetIndex offsetIndex;

        IndexStoreImpl(ColumnChunkMetaData meta) {
            OffsetIndex oi;
            this.meta = meta;
            try {
                oi = ColumnIndexStoreImpl.this.reader.readOffsetIndex(meta);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read offset index for column {}", (Object)meta.getPath(), (Object)e);
                oi = null;
            }
            if (oi == null) {
                throw new ColumnIndexStore.MissingOffsetIndexException(meta.getPath());
            }
            this.offsetIndex = oi;
        }

        @Override
        public ColumnIndex getColumnIndex() {
            if (!this.columnIndexRead) {
                try {
                    this.columnIndex = ColumnIndexStoreImpl.this.reader.readColumnIndex(this.meta);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to read column index for column {}", (Object)this.meta.getPath(), (Object)e);
                }
                this.columnIndexRead = true;
            }
            return this.columnIndex;
        }

        @Override
        public OffsetIndex getOffsetIndex() {
            return this.offsetIndex;
        }
    }

    private static interface IndexStore {
        public ColumnIndex getColumnIndex();

        public OffsetIndex getOffsetIndex();
    }
}

