/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.io;

import com.dataiku.dss.shadelib.org.apache.parquet.io.PositionOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class DelegatingPositionOutputStream
extends PositionOutputStream {
    private final OutputStream stream;

    public DelegatingPositionOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    @Override
    public void close() throws IOException {
        try (OutputStream os = this.stream;){
            os.flush();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public abstract long getPos() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }
}

