/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.variant;

import com.dataiku.dss.shadelib.org.apache.parquet.variant.Metadata;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.MetadataBuilder;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.Variant;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.VariantArrayBuilder;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.VariantObjectBuilder;
import com.dataiku.dss.shadelib.org.apache.parquet.variant.VariantUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public class VariantBuilder {
    protected byte[] writeBuffer = new byte[1024];
    protected int writePos = 0;
    protected Metadata metadata;
    protected VariantObjectBuilder objectBuilder = null;
    protected VariantArrayBuilder arrayBuilder = null;

    public VariantBuilder() {
        this.metadata = new MetadataBuilder();
    }

    public VariantBuilder(Metadata metadata) {
        this.metadata = metadata;
    }

    public Variant build() {
        if (this.objectBuilder != null) {
            throw new IllegalStateException("Cannot call build() while an object is being built. Must call endObject() first.");
        }
        if (this.arrayBuilder != null) {
            throw new IllegalStateException("Cannot call build() while an array is being built. Must call endArray() first.");
        }
        ByteBuffer metadataBuffer = this.metadata.getEncodedBuffer();
        return new Variant(ByteBuffer.wrap(this.writeBuffer, 0, this.writePos), metadataBuffer);
    }

    public ByteBuffer encodedValue() {
        return ByteBuffer.wrap(this.writeBuffer, 0, this.writePos);
    }

    public void appendEncodedValue(ByteBuffer value) {
        this.onAppend();
        int size = VariantUtil.valueSize(value);
        this.checkCapacity(size);
        value.duplicate().get(this.writeBuffer, this.writePos, size);
        this.writePos += size;
    }

    public void appendString(String str) {
        this.onAppend();
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        boolean longStr = data.length > 63;
        this.checkCapacity((longStr ? 5 : 1) + data.length);
        if (longStr) {
            this.writeBuffer[this.writePos] = VariantUtil.HEADER_LONG_STRING;
            ++this.writePos;
            VariantUtil.writeLong(this.writeBuffer, this.writePos, data.length, 4);
            this.writePos += 4;
        } else {
            this.writeBuffer[this.writePos] = VariantUtil.shortStrHeader(data.length);
            ++this.writePos;
        }
        System.arraycopy(data, 0, this.writeBuffer, this.writePos, data.length);
        this.writePos += data.length;
    }

    public void appendNull() {
        this.onAppend();
        this.checkCapacity(1);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_NULL;
        ++this.writePos;
    }

    public void appendNullIfEmpty() {
        if (this.writePos == 0) {
            this.appendNull();
        }
    }

    public void appendBoolean(boolean b) {
        this.onAppend();
        this.checkCapacity(1);
        this.writeBuffer[this.writePos] = b ? VariantUtil.HEADER_TRUE : VariantUtil.HEADER_FALSE;
        ++this.writePos;
    }

    public void appendLong(long l) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_INT64;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, l, 8);
        this.writePos += 9;
    }

    public void appendInt(int i) {
        this.onAppend();
        this.checkCapacity(5);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_INT32;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, i, 4);
        this.writePos += 5;
    }

    public void appendShort(short s2) {
        this.onAppend();
        this.checkCapacity(3);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_INT16;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, s2, 2);
        this.writePos += 3;
    }

    public void appendByte(byte b) {
        this.onAppend();
        this.checkCapacity(2);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_INT8;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, b, 1);
        this.writePos += 2;
    }

    public void appendDouble(double d) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_DOUBLE;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, Double.doubleToLongBits(d), 8);
        this.writePos += 9;
    }

    public void appendDecimal(BigDecimal d) {
        this.onAppend();
        BigInteger unscaled = d.unscaledValue();
        if (d.scale() <= 9 && d.precision() <= 9) {
            this.checkCapacity(6);
            this.writeBuffer[this.writePos] = VariantUtil.HEADER_DECIMAL4;
            this.writeBuffer[this.writePos + 1] = (byte)d.scale();
            VariantUtil.writeLong(this.writeBuffer, this.writePos + 2, unscaled.intValueExact(), 4);
            this.writePos += 6;
        } else if (d.scale() <= 18 && d.precision() <= 18) {
            this.checkCapacity(10);
            this.writeBuffer[this.writePos] = VariantUtil.HEADER_DECIMAL8;
            this.writeBuffer[this.writePos + 1] = (byte)d.scale();
            VariantUtil.writeLong(this.writeBuffer, this.writePos + 2, unscaled.longValueExact(), 8);
            this.writePos += 10;
        } else {
            assert (d.scale() <= 38 && d.precision() <= 38);
            this.checkCapacity(18);
            this.writeBuffer[this.writePos] = VariantUtil.HEADER_DECIMAL16;
            this.writeBuffer[this.writePos + 1] = (byte)d.scale();
            this.writePos += 2;
            byte[] bytes = unscaled.toByteArray();
            for (int i = 0; i < bytes.length; ++i) {
                this.writeBuffer[this.writePos + i] = bytes[bytes.length - 1 - i];
            }
            byte sign = (byte)(bytes[0] < 0 ? -1 : 0);
            for (int i = bytes.length; i < 16; ++i) {
                this.writeBuffer[this.writePos + i] = sign;
            }
            this.writePos += 16;
        }
    }

    public void appendDate(int daysSinceEpoch) {
        this.onAppend();
        this.checkCapacity(5);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_DATE;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, daysSinceEpoch, 4);
        this.writePos += 5;
    }

    public void appendTimestampTz(long microsSinceEpoch) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_TIMESTAMP_TZ;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, microsSinceEpoch, 8);
        this.writePos += 9;
    }

    public void appendTimestampNtz(long microsSinceEpoch) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_TIMESTAMP_NTZ;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, microsSinceEpoch, 8);
        this.writePos += 9;
    }

    public void appendTime(long microsSinceMidnight) {
        if (microsSinceMidnight < 0L) {
            throw new IllegalArgumentException(String.format("Time value (%d) cannot be negative.", microsSinceMidnight));
        }
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_TIME;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, microsSinceMidnight, 8);
        this.writePos += 9;
    }

    public void appendTimestampNanosTz(long nanosSinceEpoch) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_TIMESTAMP_NANOS_TZ;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, nanosSinceEpoch, 8);
        this.writePos += 9;
    }

    public void appendTimestampNanosNtz(long nanosSinceEpoch) {
        this.onAppend();
        this.checkCapacity(9);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_TIMESTAMP_NANOS_NTZ;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, nanosSinceEpoch, 8);
        this.writePos += 9;
    }

    public void appendFloat(float f) {
        this.onAppend();
        this.checkCapacity(5);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_FLOAT;
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, Float.floatToIntBits(f), 8);
        this.writePos += 5;
    }

    public void appendBinary(ByteBuffer binary) {
        this.onAppend();
        int binarySize = binary.remaining();
        this.checkCapacity(5 + binarySize);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_BINARY;
        ++this.writePos;
        VariantUtil.writeLong(this.writeBuffer, this.writePos, binarySize, 4);
        this.writePos += 4;
        ByteBuffer.wrap(this.writeBuffer, this.writePos, binarySize).put(binary);
        this.writePos += binarySize;
    }

    public void appendUUID(UUID uuid) {
        this.onAppend();
        this.checkCapacity(17);
        this.writeBuffer[this.writePos] = VariantUtil.HEADER_UUID;
        ++this.writePos;
        ByteBuffer bb = ByteBuffer.wrap(this.writeBuffer, this.writePos, 16).order(ByteOrder.BIG_ENDIAN);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        this.writePos += 16;
    }

    void appendUUIDBytes(ByteBuffer bytes) {
        this.checkCapacity(17);
        this.writeBuffer[this.writePos++] = VariantUtil.primitiveHeader(20);
        if (bytes.remaining() < 16) {
            throw new IllegalArgumentException("UUID must be exactly 16 bytes");
        }
        bytes.duplicate().get(this.writeBuffer, this.writePos, 16);
        this.writePos += 16;
    }

    public VariantObjectBuilder startObject() {
        this.onStartNested();
        if (this.objectBuilder != null) {
            throw new IllegalStateException("Cannot call startObject() without calling endObject() first.");
        }
        if (this.arrayBuilder != null) {
            throw new IllegalStateException("Cannot call startObject() without calling endArray() first.");
        }
        this.objectBuilder = new VariantObjectBuilder(this.metadata);
        return this.objectBuilder;
    }

    public VariantObjectBuilder startOrContinueObject() {
        if (this.objectBuilder != null) {
            return this.objectBuilder;
        }
        return this.startObject();
    }

    public VariantObjectBuilder startOrContinuePartialObject(ByteBuffer value, Set<String> suppressedKeys) {
        VariantObjectBuilder objectBuilder = this.startOrContinueObject();
        Variant variant = new Variant(value, this.metadata);
        for (int index = 0; index < variant.numObjectElements(); ++index) {
            Variant.ObjectField field = variant.getFieldAtIndex(index);
            if (suppressedKeys.contains(field.key)) continue;
            objectBuilder.appendKey(field.key);
            objectBuilder.appendEncodedValue(field.value.getValueBuffer());
        }
        return objectBuilder;
    }

    public void endObjectIfExists() {
        if (this.objectBuilder != null) {
            this.endObject();
        }
    }

    public void endObject() {
        if (this.objectBuilder == null) {
            throw new IllegalStateException("Cannot call endObject() without calling startObject() first.");
        }
        ArrayList<FieldEntry> fields = this.objectBuilder.validateAndGetFields();
        int numFields = fields.size();
        Collections.sort(fields);
        int maxId = numFields == 0 ? 0 : fields.get((int)0).id;
        int dataSize = numFields == 0 ? 0 : fields.get((int)0).valueSize;
        int distinctPos = 0;
        for (int i = 1; i < numFields; ++i) {
            maxId = Math.max(maxId, fields.get((int)i).id);
            if (fields.get((int)i).id == fields.get((int)(i - 1)).id) {
                if (fields.get((int)distinctPos).offset >= fields.get((int)i).offset) continue;
                fields.set(distinctPos, fields.get(i));
                continue;
            }
            fields.set(++distinctPos, fields.get(i));
            dataSize += fields.get((int)i).valueSize;
        }
        if (distinctPos + 1 < fields.size()) {
            numFields = distinctPos + 1;
            fields.subList(numFields, fields.size()).clear();
        }
        boolean largeSize = numFields > 255;
        int sizeBytes = largeSize ? 4 : 1;
        int idSize = VariantBuilder.getMinIntegerSize(maxId);
        int offsetSize = VariantBuilder.getMinIntegerSize(dataSize);
        int dataOffset = 1 + sizeBytes + numFields * idSize + (numFields + 1) * offsetSize;
        this.checkCapacity(dataOffset + dataSize);
        this.writeBuffer[this.writePos] = VariantUtil.objectHeader(largeSize, idSize, offsetSize);
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, numFields, sizeBytes);
        int idStart = this.writePos + 1 + sizeBytes;
        int offsetStart = idStart + numFields * idSize;
        int currOffset = 0;
        for (int i = 0; i < numFields; ++i) {
            FieldEntry field = fields.get(i);
            VariantUtil.writeLong(this.writeBuffer, idStart + i * idSize, field.id, idSize);
            VariantUtil.writeLong(this.writeBuffer, offsetStart + i * offsetSize, currOffset, offsetSize);
            System.arraycopy(this.objectBuilder.writeBuffer, field.offset, this.writeBuffer, this.writePos + dataOffset + currOffset, field.valueSize);
            currOffset += field.valueSize;
        }
        VariantUtil.writeLong(this.writeBuffer, offsetStart + numFields * offsetSize, dataSize, offsetSize);
        this.writePos += dataOffset + dataSize;
        this.objectBuilder = null;
    }

    public VariantArrayBuilder startArray() {
        this.onStartNested();
        if (this.objectBuilder != null) {
            throw new IllegalStateException("Cannot call startArray() without calling endObject() first.");
        }
        if (this.arrayBuilder != null) {
            throw new IllegalStateException("Cannot call startArray() without calling endArray() first.");
        }
        this.arrayBuilder = new VariantArrayBuilder(this.metadata);
        return this.arrayBuilder;
    }

    public void endArray() {
        if (this.arrayBuilder == null) {
            throw new IllegalStateException("Cannot call endArray() without calling startArray() first.");
        }
        ArrayList<Integer> offsets = this.arrayBuilder.validateAndGetOffsets();
        int numElements = offsets.size();
        int dataSize = this.arrayBuilder.writePos;
        boolean largeSize = numElements > 255;
        int sizeBytes = largeSize ? 4 : 1;
        int offsetSize = VariantBuilder.getMinIntegerSize(dataSize);
        int dataOffset = 1 + sizeBytes + (numElements + 1) * offsetSize;
        this.checkCapacity(dataOffset + dataSize);
        System.arraycopy(this.arrayBuilder.writeBuffer, 0, this.writeBuffer, this.writePos + dataOffset, dataSize);
        this.writeBuffer[this.writePos] = VariantUtil.arrayHeader(largeSize, offsetSize);
        VariantUtil.writeLong(this.writeBuffer, this.writePos + 1, numElements, sizeBytes);
        int offsetStart = this.writePos + 1 + sizeBytes;
        for (int i = 0; i < numElements; ++i) {
            VariantUtil.writeLong(this.writeBuffer, offsetStart + i * offsetSize, offsets.get(i).intValue(), offsetSize);
        }
        VariantUtil.writeLong(this.writeBuffer, offsetStart + numElements * offsetSize, dataSize, offsetSize);
        this.writePos += dataOffset + dataSize;
        this.arrayBuilder = null;
    }

    protected void onAppend() {
        this.checkAppendWhileNested();
        if (this.writePos > 0) {
            throw new IllegalStateException("Cannot call multiple append() methods.");
        }
    }

    protected void onStartNested() {
        this.checkMultipleNested("Cannot call startObject()/startArray() without calling endObject()/endArray() first.");
        if (this.writePos > 0) {
            throw new IllegalStateException("Cannot call startObject()/startArray() after appending a value.");
        }
    }

    protected void checkMultipleNested(String message) {
        if (this.objectBuilder != null || this.arrayBuilder != null) {
            throw new IllegalStateException(message);
        }
    }

    protected void checkAppendWhileNested() {
        if (this.objectBuilder != null) {
            throw new IllegalStateException("Cannot call append() methods while an object is being built. Must call endObject() first.");
        }
        if (this.arrayBuilder != null) {
            throw new IllegalStateException("Cannot call append() methods while an array is being built. Must call endArray() first.");
        }
    }

    int addDictionaryKey(String key) {
        return this.metadata.getOrInsert(key);
    }

    int writePos() {
        return this.writePos;
    }

    private void checkCapacity(int additionalBytes) {
        int requiredBytes = this.writePos + additionalBytes;
        if (requiredBytes > this.writeBuffer.length) {
            int newCapacity = Integer.highestOneBit(requiredBytes);
            newCapacity = newCapacity < requiredBytes ? newCapacity * 2 : newCapacity;
            byte[] newValue = new byte[newCapacity];
            System.arraycopy(this.writeBuffer, 0, newValue, 0, this.writePos);
            this.writeBuffer = newValue;
        }
    }

    public static int getMinIntegerSize(int value) {
        assert (value >= 0);
        if (value <= 255) {
            return 1;
        }
        if (value <= 65535) {
            return 2;
        }
        if (value <= 0xFFFFFF) {
            return 3;
        }
        return 4;
    }

    static final class FieldEntry
    implements Comparable<FieldEntry> {
        final String key;
        final int id;
        final int offset;
        int valueSize = 0;

        FieldEntry(String key, int id, int offset) {
            this.key = key;
            this.id = id;
            this.offset = offset;
        }

        void updateValueSize(int size) {
            this.valueSize = size;
        }

        @Override
        public int compareTo(FieldEntry other) {
            return this.key.compareTo(other.key);
        }
    }
}

