/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.Configuration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ClassMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AbstractConfiguration
implements Configuration {
    private final boolean _enabledByDefault;
    private final List<String> _after;
    private final List<String> _before;
    private final ClassMatcher _protected;
    private final ClassMatcher _hidden;

    protected AbstractConfiguration(Builder builder) {
        this._enabledByDefault = builder._enabledByDefault;
        this._after = List.copyOf(builder._after);
        this._before = List.copyOf(builder._before);
        this._protected = new ClassMatcher(builder._system).asImmutable();
        this._hidden = new ClassMatcher(builder._server).asImmutable();
    }

    @Override
    public Collection<String> getDependents() {
        return this._after;
    }

    @Override
    public Collection<String> getDependencies() {
        return this._before;
    }

    @Override
    public ClassMatcher getProtectedClasses() {
        return this._protected;
    }

    @Override
    public ClassMatcher getHiddenClasses() {
        return this._hidden;
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void destroy(WebAppContext context) throws Exception {
    }

    @Override
    public boolean isEnabledByDefault() {
        return this._enabledByDefault;
    }

    @Override
    public boolean abort(WebAppContext context) {
        return false;
    }

    public static class Builder {
        private boolean _enabledByDefault = true;
        private final List<String> _after = new ArrayList<String>();
        private final List<String> _before = new ArrayList<String>();
        private final ClassMatcher _system = new ClassMatcher();
        private final ClassMatcher _server = new ClassMatcher();

        public Builder enabledByDefault(boolean enabledByDefault) {
            this._enabledByDefault = enabledByDefault;
            return this;
        }

        public Builder addDependencies(String ... classes) {
            Collections.addAll(this._before, classes);
            return this;
        }

        @SafeVarargs
        public final Builder addDependencies(Class<? extends Configuration> ... classes) {
            this.addDependencies(Arrays.stream(classes).map(Class::getName).toList().toArray(new String[classes.length]));
            return this;
        }

        public Builder addDependents(String ... classes) {
            this._after.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder addDependents(Class<?> ... classes) {
            this.addDependents(Arrays.stream(classes).map(Class::getName).toList().toArray(new String[classes.length]));
            return this;
        }

        public Builder protect(String ... classes) {
            this._system.add(classes);
            return this;
        }

        public Builder hide(String ... classes) {
            this._server.add(classes);
            return this;
        }

        public Builder expose(String ... classes) {
            for (String c : classes) {
                if (c.startsWith("-")) {
                    throw new IllegalArgumentException();
                }
                this._server.add("-" + c);
            }
            return this;
        }

        public Builder protectAndExpose(String ... classes) {
            for (String c : classes) {
                if (c.startsWith("-")) {
                    throw new IllegalArgumentException();
                }
                this._system.add(c);
                this._server.add("-" + c);
            }
            return this;
        }
    }
}

