/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.JettyServerUpgradeResponse;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpFields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.ExtensionConfig;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DelegatedServerUpgradeResponse
implements JettyServerUpgradeResponse {
    private final ServerUpgradeResponse upgradeResponse;
    private final HttpServletResponse httpServletResponse;
    private final Map<String, List<String>> headers;

    public DelegatedServerUpgradeResponse(ServerUpgradeResponse response) {
        this.upgradeResponse = response;
        ServletContextResponse servletContextResponse = Response.as(response, ServletContextResponse.class);
        this.httpServletResponse = (HttpServletResponse)servletContextResponse.getRequest().getAttribute("com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.wrappedResponse");
        this.headers = HttpFields.asMap(this.upgradeResponse.getHeaders());
    }

    @Override
    public void addHeader(String name, String value) {
        this.upgradeResponse.getHeaders().add(name, value);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, List.of(value));
    }

    @Override
    public void setHeader(String name, List<String> values2) {
        this.headers.put(name, values2);
    }

    @Override
    public String getAcceptedSubProtocol() {
        return this.upgradeResponse.getAcceptedSubProtocol();
    }

    @Override
    public List<com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.ExtensionConfig> getExtensions() {
        return this.upgradeResponse.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    @Override
    public String getHeader(String name) {
        return this.upgradeResponse.getHeaders().get(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.upgradeResponse.getHeaders().getFieldNamesCollection();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<String> getHeaders(String name) {
        return this.upgradeResponse.getHeaders().getValuesList(name);
    }

    @Override
    public int getStatusCode() {
        return this.httpServletResponse.getStatus();
    }

    @Override
    public void sendForbidden(String message) throws IOException {
        this.httpServletResponse.sendError(403, message);
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
        this.upgradeResponse.setAcceptedSubProtocol(protocol);
    }

    @Override
    public void setExtensions(List<com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.ExtensionConfig> configs) {
        this.upgradeResponse.setExtensions(configs.stream().map(c -> new ExtensionConfig(c.getName(), c.getParameters())).collect(Collectors.toList()));
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.httpServletResponse.setStatus(statusCode);
    }

    @Override
    public boolean isCommitted() {
        return this.httpServletResponse.isCommitted();
    }

    @Override
    public void sendError(int statusCode, String message) throws IOException {
        this.httpServletResponse.sendError(statusCode, message);
    }
}

