/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.io.content;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Content;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ExceptionUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Invocable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.SerializedInvoker;
import java.util.Objects;

public abstract class ContentSourceTransformer
implements Content.Source {
    private final SerializedInvoker invoker;
    private final Content.Source rawSource;
    private Content.Chunk rawChunk;
    private Content.Chunk transformedChunk;
    private volatile boolean needsRawRead;
    private volatile Runnable demandCallback;

    protected ContentSourceTransformer(Content.Source rawSource) {
        this(rawSource, new SerializedInvoker(ContentSourceTransformer.class));
    }

    protected ContentSourceTransformer(Content.Source rawSource, SerializedInvoker invoker) {
        this.rawSource = rawSource;
        this.invoker = invoker;
    }

    protected Content.Source getContentSource() {
        return this.rawSource;
    }

    @Override
    public Content.Chunk read() {
        while (true) {
            if (this.needsRawRead) {
                this.rawChunk = this.rawSource.read();
                boolean bl = this.needsRawRead = this.rawChunk == null;
                if (this.rawChunk == null) {
                    return null;
                }
            }
            if (Content.Chunk.isFailure(this.rawChunk)) {
                Content.Chunk failure = this.rawChunk;
                this.rawChunk = Content.Chunk.next(this.rawChunk);
                this.needsRawRead = this.rawChunk == null;
                return failure;
            }
            if (Content.Chunk.isFailure(this.transformedChunk)) {
                return this.transformedChunk;
            }
            this.transformedChunk = this.process(this.rawChunk);
            if (this.rawChunk != null && this.rawChunk != this.transformedChunk) {
                this.rawChunk.release();
            }
            this.rawChunk = null;
            if (this.transformedChunk != null) {
                Content.Chunk result = this.transformedChunk;
                this.transformedChunk = Content.Chunk.next(result);
                return result;
            }
            this.needsRawRead = true;
        }
    }

    @Override
    public void demand(Runnable demandCallback) {
        this.demandCallback = Objects.requireNonNull(demandCallback);
        if (this.needsRawRead) {
            this.rawSource.demand(new DemandTask(Invocable.getInvocationType(demandCallback), this::invokeDemandCallback));
        } else {
            this.invoker.run(this::invokeDemandCallback);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.rawSource.fail(failure);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback = this.demandCallback;
        this.demandCallback = null;
        if (demandCallback != null) {
            ExceptionUtil.run(demandCallback, this::fail);
        }
    }

    private Content.Chunk process(Content.Chunk rawChunk) {
        try {
            return this.transform(rawChunk);
        }
        catch (Throwable x) {
            this.fail(x);
            return Content.Chunk.from(x);
        }
    }

    protected abstract Content.Chunk transform(Content.Chunk var1);

    private class DemandTask
    extends Invocable.Task.Abstract {
        private final Runnable invokeDemandCallback;

        private DemandTask(Invocable.InvocationType invocationType, Runnable invokeDemandCallback) {
            super(invocationType);
            this.invokeDemandCallback = invokeDemandCallback;
        }

        @Override
        public void run() {
            ContentSourceTransformer.this.invoker.run(this.invokeDemandCallback);
        }
    }
}

