/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.session;

import com.dataiku.dss.shadelib.org.eclipse.jetty.session.AbstractSessionDataStore;
import com.dataiku.dss.shadelib.org.eclipse.jetty.session.SessionData;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Objects;

public abstract class ObjectStreamSessionDataStore
extends AbstractSessionDataStore {
    public ObjectOutputStream newObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    protected ObjectInputStream newObjectInputStream(InputStream is) throws IOException {
        return new ClassLoadingObjectInputStream(is);
    }

    protected void serializeAttributes(SessionData data, OutputStream os) throws Exception {
        Objects.requireNonNull(data);
        Objects.requireNonNull(os);
        try (ObjectOutputStream oos = this.newObjectOutputStream(os);){
            SessionData.serializeAttributes(data, oos);
        }
    }

    protected void deserializeAttributes(SessionData data, InputStream is) throws Exception {
        Objects.requireNonNull(data);
        Objects.requireNonNull(is);
        try (ObjectInputStream ois = this.newObjectInputStream(is);){
            SessionData.deserializeAttributes(data, ois);
        }
    }
}

