/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.ByteArrayOutputStream2;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.CharsetStringBuilder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Fields;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.IO;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.MultiMap;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.TypeUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Utf8StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlEncoded {
    static final Logger LOG;
    public static final Charset ENCODING;

    private UrlEncoded() {
    }

    public static String encode(MultiMap<String> map, Charset charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            int s2 = list.size();
            if (delim) {
                result.append('&');
            }
            if (s2 == 0) {
                result.append(UrlEncoded.encodeString(key, charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                for (int i = 0; i < s2; ++i) {
                    if (i > 0) {
                        result.append('&');
                    }
                    String val = (String)list.get(i);
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (val != null) {
                        if (!val.isEmpty()) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(val, charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result.append('=');
                }
            }
            delim = true;
        }
        return result.toString();
    }

    public static MultiMap<String> decodeQuery(String query) {
        MultiMap<String> map = new MultiMap<String>();
        if (StringUtil.isNotBlank(query)) {
            UrlEncoded.decodeUtf8To(query, 0, query.length(), map);
        }
        return map;
    }

    @Deprecated(since="10", forRemoval=true)
    public static void decodeTo(String content, MultiMap<String> map, String charset) {
        UrlEncoded.decodeTo(content, map, charset == null ? null : Charset.forName(charset));
    }

    public static void decodeTo(String content, MultiMap<String> map, Charset charset) {
        UrlEncoded.decodeTo(content, map::add, charset);
    }

    public static void decodeTo(String content, MultiMap<String> map, Charset charset, int maxKeys) {
        UrlEncoded.decodeTo(content, (String key, String val) -> {
            map.add((String)key, (String)val);
            UrlEncoded.checkMaxKeys(map, maxKeys);
        }, charset);
    }

    public static void decodeTo(String content, BiConsumer<String, String> adder, Charset charset, int maxKeys) {
        AtomicInteger keys2 = new AtomicInteger(0);
        UrlEncoded.decodeTo(content, (String key, String val) -> {
            adder.accept((String)key, (String)val);
            UrlEncoded.checkMaxKeys(keys2.incrementAndGet(), maxKeys);
        }, charset);
    }

    public static void decodeTo(String content, BiConsumer<String, String> adder, Charset charset) {
        String value;
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(content, 0, content.length(), adder);
            return;
        }
        String key = null;
        int mark = -1;
        boolean encoded = false;
        block5: for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            switch (c) {
                case '&': {
                    int l = i - mark - 1;
                    value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1, i));
                    mark = i;
                    encoded = false;
                    if (key != null) {
                        adder.accept(key, value);
                    } else if (value != null && !value.isEmpty()) {
                        adder.accept(value, "");
                    }
                    key = null;
                    continue block5;
                }
                case '=': {
                    if (key != null) continue block5;
                    key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                    mark = i;
                    encoded = false;
                    continue block5;
                }
                case '%': 
                case '+': {
                    encoded = true;
                }
            }
        }
        if (key != null) {
            int l = content.length() - mark - 1;
            value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l, charset) : content.substring(mark + 1));
            adder.accept(key, value);
        } else if (mark < content.length()) {
            String string = key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
            if (key != null && !key.isEmpty()) {
                adder.accept(key, "");
            }
        }
    }

    @Deprecated
    public static void decodeUtf8To(String query, MultiMap<String> map) {
        UrlEncoded.decodeUtf8To(query, 0, query.length(), map);
    }

    public static void decodeUtf8To(String query, Fields fields) {
        UrlEncoded.decodeUtf8To(query, 0, query.length(), fields);
    }

    @Deprecated
    public static void decodeUtf8To(String query, int offset, int length, MultiMap<String> map) {
        UrlEncoded.decodeUtf8To(query, offset, length, map::add);
    }

    public static void decodeUtf8To(String uri, int offset, int length, Fields fields) {
        UrlEncoded.decodeUtf8To(uri, offset, length, fields::add);
    }

    public static boolean decodeUtf8To(String query, int offset, int length, BiConsumer<String, String> adder) throws Utf8StringBuilder.Utf8IllegalArgumentException {
        return UrlEncoded.decodeUtf8To(query, offset, length, adder, false, false, false);
    }

    public static boolean decodeUtf8To(String query, int offset, int length, BiConsumer<String, String> adder, boolean allowBadPercent, boolean allowBadUtf8, boolean allowTruncatedUtf8) throws Utf8StringBuilder.Utf8IllegalArgumentException {
        String value;
        Supplier<Utf8StringBuilder.Utf8IllegalArgumentException> onCodingError;
        AtomicBoolean badUtf8;
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        String key = null;
        if (allowBadUtf8) {
            badUtf8 = new AtomicBoolean(false);
            onCodingError = () -> {
                badUtf8.set(true);
                return null;
            };
        } else {
            badUtf8 = null;
            onCodingError = Utf8StringBuilder.Utf8IllegalArgumentException::new;
        }
        int end = offset + length;
        block8: for (int i = offset; i < end; ++i) {
            char c = query.charAt(i);
            switch (c) {
                case '&': {
                    value = UrlEncoded.take(allowBadUtf8, allowTruncatedUtf8, buffer, badUtf8, onCodingError);
                    if (key != null) {
                        adder.accept(key, value);
                    } else if (value != null && !value.isEmpty()) {
                        adder.accept(value, "");
                    }
                    key = null;
                    continue block8;
                }
                case '=': {
                    if (key != null) {
                        buffer.append(c);
                        continue block8;
                    }
                    key = UrlEncoded.take(allowBadUtf8, allowTruncatedUtf8, buffer, badUtf8, onCodingError);
                    continue block8;
                }
                case '+': {
                    buffer.append((byte)32);
                    continue block8;
                }
                case '%': {
                    if (i + 2 < end) {
                        char hi = query.charAt(++i);
                        char lo = query.charAt(++i);
                        try {
                            UrlEncoded.decodeHexByteTo(buffer, hi, lo);
                        }
                        catch (NumberFormatException e) {
                            boolean replaced = buffer.replaceIncomplete();
                            if (replaced && !allowBadUtf8 || !allowBadPercent) {
                                throw e;
                            }
                            if (hi == '&' || key == null && hi == '=') {
                                if (!replaced) {
                                    buffer.append('%');
                                }
                                i -= 2;
                                continue block8;
                            }
                            if (lo == '&' || key == null && lo == '=') {
                                if (!replaced) {
                                    buffer.append('%');
                                    buffer.append(hi);
                                }
                                --i;
                                continue block8;
                            }
                            if (replaced) continue block8;
                            buffer.append('%');
                            buffer.append(hi);
                            buffer.append(lo);
                        }
                        continue block8;
                    }
                    if (buffer.replaceIncomplete()) {
                        if (!allowBadUtf8 || !allowBadPercent) {
                            throw new Utf8StringBuilder.Utf8IllegalArgumentException();
                        }
                        i = end;
                        continue block8;
                    }
                    if (allowBadPercent) {
                        buffer.append('%');
                        continue block8;
                    }
                    throw new Utf8StringBuilder.Utf8IllegalArgumentException();
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (key != null) {
            value = UrlEncoded.take(allowBadUtf8, allowTruncatedUtf8, buffer, badUtf8, onCodingError);
            adder.accept(key, value);
        } else if (buffer.length() > 0) {
            key = UrlEncoded.take(allowBadUtf8, allowTruncatedUtf8, buffer, badUtf8, onCodingError);
            adder.accept(key, "");
        }
        return badUtf8 == null || !badUtf8.get();
    }

    private static <X extends Throwable> String take(boolean allowBadUtf8, Boolean allowTruncatedUtf8, Utf8StringBuilder buffer, AtomicBoolean badUtf8, Supplier<X> onCodingError) throws X {
        if (!allowBadUtf8 && !allowTruncatedUtf8.booleanValue()) {
            return buffer.takeCompleteString(onCodingError);
        }
        boolean codingError = buffer.hasCodingErrors();
        if (codingError && !allowBadUtf8) {
            return buffer.takeCompleteString(onCodingError);
        }
        if (buffer.replaceIncomplete() && !allowTruncatedUtf8.booleanValue()) {
            return buffer.takeCompleteString(onCodingError);
        }
        String result = buffer.takeCompleteString(null);
        buffer.reset();
        if (badUtf8 != null) {
            badUtf8.set(true);
        }
        return result;
    }

    public static void decode88591To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        UrlEncoded.decode88591To(in, map::add, maxLength, maxKeys);
    }

    public static void decode88591To(InputStream in, BiConsumer<String, String> adder, int maxLength, int maxKeys) throws IOException {
        String value;
        int b;
        StringBuilder buffer = new StringBuilder();
        String key = null;
        int totalLength = 0;
        int keys2 = 0;
        while ((b = in.read()) >= 0) {
            switch ((char)b) {
                case '&': {
                    value = buffer.isEmpty() ? "" : buffer.toString();
                    buffer.setLength(0);
                    if (key != null) {
                        adder.accept(key, value);
                        ++keys2;
                    } else if (!value.isEmpty()) {
                        adder.accept(value, "");
                        ++keys2;
                    }
                    key = null;
                    UrlEncoded.checkMaxKeys(keys2, maxKeys);
                    break;
                }
                case '=': {
                    if (key != null) {
                        buffer.append((char)b);
                        break;
                    }
                    key = buffer.toString();
                    buffer.setLength(0);
                    break;
                }
                case '+': {
                    buffer.append(' ');
                    break;
                }
                case '%': {
                    int code0 = in.read();
                    int code1 = in.read();
                    buffer.append(UrlEncoded.decodeHexChar(code0, code1));
                    break;
                }
                default: {
                    buffer.append((char)b);
                }
            }
            UrlEncoded.checkMaxLength(++totalLength, maxLength);
        }
        if (key != null) {
            value = buffer.isEmpty() ? "" : buffer.toString();
            buffer.setLength(0);
            adder.accept(key, value);
            ++keys2;
        } else if (!buffer.isEmpty()) {
            adder.accept(buffer.toString(), "");
            ++keys2;
        }
        UrlEncoded.checkMaxKeys(keys2, maxKeys);
    }

    public static void decodeUtf8To(InputStream in, Fields fields, int maxLength, int maxKeys) throws IOException {
        UrlEncoded.decodeUtf8To(in, fields::add, maxLength, maxKeys);
    }

    @Deprecated(since="12.0.17", forRemoval=true)
    public static void decodeUtf8To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        UrlEncoded.decodeUtf8To(in, map::add, maxLength, maxKeys);
    }

    public static void decodeUtf8To(InputStream in, BiConsumer<String, String> adder, int maxLength, int maxKeys) throws IOException {
        String value;
        int b;
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        String key = null;
        int totalLength = 0;
        int keys2 = 0;
        while ((b = in.read()) >= 0) {
            switch ((char)b) {
                case '&': {
                    value = buffer.toCompleteString();
                    buffer.reset();
                    if (key != null) {
                        adder.accept(key, value);
                        ++keys2;
                    } else if (value != null && !value.isEmpty()) {
                        adder.accept(value, "");
                        ++keys2;
                    }
                    key = null;
                    UrlEncoded.checkMaxKeys(keys2, maxKeys);
                    break;
                }
                case '=': {
                    if (key != null) {
                        buffer.append((byte)b);
                        break;
                    }
                    key = buffer.toCompleteString();
                    buffer.reset();
                    break;
                }
                case '+': {
                    buffer.append((byte)32);
                    break;
                }
                case '%': {
                    char code0 = (char)in.read();
                    char code1 = (char)in.read();
                    buffer.append(UrlEncoded.decodeHexByte(code0, code1));
                    break;
                }
                default: {
                    buffer.append((byte)b);
                }
            }
            UrlEncoded.checkMaxLength(++totalLength, maxLength);
        }
        if (key != null) {
            value = buffer.toCompleteString();
            buffer.reset();
            adder.accept(key, value);
            ++keys2;
        } else if (buffer.length() > 0) {
            adder.accept(buffer.toCompleteString(), "");
            ++keys2;
        }
        UrlEncoded.checkMaxKeys(keys2, maxKeys);
    }

    public static void decodeUtf16To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        UrlEncoded.decodeUtf16To(in, map::add, maxLength, maxKeys);
    }

    public static void decodeUtf16To(InputStream in, BiConsumer<String, String> adder, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input = new InputStreamReader(in, StandardCharsets.UTF_16);
        StringWriter buf = new StringWriter(8192);
        IO.copy(input, buf, (long)maxLength);
        UrlEncoded.decodeTo(buf.getBuffer().toString(), adder, StandardCharsets.UTF_16, maxKeys);
    }

    public static Charset decodeCharset(String charsetName) {
        if (charsetName == null) {
            return ENCODING;
        }
        return Charset.forName(charsetName);
    }

    public static void decodeTo(InputStream in, MultiMap<String> map, Charset charset, int maxLength, int maxKeys) throws IOException {
        UrlEncoded.decodeTo(in, map::add, charset, maxLength, maxKeys);
    }

    public static void decodeTo(InputStream in, BiConsumer<String, String> adder, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, adder, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.ISO_8859_1.equals(charset)) {
            UrlEncoded.decode88591To(in, adder, maxLength, maxKeys);
            return;
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, adder, maxLength, maxKeys);
            return;
        }
        String key = null;
        int totalLength = 0;
        try (ByteArrayOutputStream2 output = new ByteArrayOutputStream2();){
            String value;
            int size;
            int c;
            int keys2 = 0;
            while ((c = in.read()) > 0) {
                switch ((char)c) {
                    case '&': {
                        size = output.size();
                        value = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        if (key != null) {
                            adder.accept(key, value);
                            ++keys2;
                        } else if (value != null && !value.isEmpty()) {
                            adder.accept(value, "");
                            ++keys2;
                        }
                        key = null;
                        UrlEncoded.checkMaxKeys(keys2, maxKeys);
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            output.write(c);
                            break;
                        }
                        size = output.size();
                        key = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        break;
                    }
                    case '+': {
                        output.write(32);
                        break;
                    }
                    case '%': {
                        int code0 = in.read();
                        int code1 = in.read();
                        output.write(UrlEncoded.decodeHexChar(code0, code1));
                        break;
                    }
                    default: {
                        output.write(c);
                    }
                }
                UrlEncoded.checkMaxLength(++totalLength, maxLength);
            }
            size = output.size();
            if (key != null) {
                value = size == 0 ? "" : output.toString(charset);
                output.setCount(0);
                adder.accept(key, value);
                ++keys2;
            } else if (size > 0) {
                adder.accept(output.toString(charset), "");
                ++keys2;
            }
            UrlEncoded.checkMaxKeys(keys2, maxKeys);
        }
    }

    private static void checkMaxKeys(int size, int maxKeys) {
        if (maxKeys >= 0 && size > maxKeys) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", size, maxKeys));
        }
    }

    private static void checkMaxKeys(MultiMap<String> map, int maxKeys) {
        int size = map.size();
        if (maxKeys >= 0 && size > maxKeys) {
            throw new IllegalStateException(String.format("Form with too many keys [%d > %d]", size, maxKeys));
        }
    }

    private static void checkMaxLength(int length, int maxLength) {
        if (maxLength >= 0 && length > maxLength) {
            throw new IllegalStateException("Form is larger than max length " + maxLength);
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), ENCODING);
    }

    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8StringBuilder buffer = null;
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuilder(length);
                        buffer.append(encoded, offset, i + 1);
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuilder(length);
                        buffer.append(encoded, offset, i);
                    }
                    buffer.append(' ');
                    continue;
                }
                if (c == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuilder(length);
                        buffer.append(encoded, offset, i);
                    }
                    if (i + 2 < length) {
                        int o = offset + i + 1;
                        i += 2;
                        byte b = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                        buffer.append(b);
                        continue;
                    }
                    buffer.append('\ufffd');
                    i = length;
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toCompleteString();
        }
        CharsetStringBuilder buffer = null;
        for (int i = 0; i < length; ++i) {
            char c = encoded.charAt(offset + i);
            if (c > '\u00ff') {
                if (buffer == null) {
                    buffer = CharsetStringBuilder.forCharset(charset);
                    buffer.append(encoded, offset, i + 1);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == '+') {
                if (buffer == null) {
                    buffer = CharsetStringBuilder.forCharset(charset);
                    buffer.append(encoded, offset, i);
                }
                buffer.append(' ');
                continue;
            }
            if (c == '%') {
                if (buffer == null) {
                    buffer = CharsetStringBuilder.forCharset(charset);
                    buffer.append(encoded, offset, i);
                }
                byte[] ba = new byte[length];
                int n = 0;
                while (c <= '\u00ff') {
                    if (c == '%') {
                        if (i + 2 < length) {
                            int o = offset + i + 1;
                            i += 3;
                            ba[n] = (byte)TypeUtil.parseInt(encoded, o, 2, 16);
                            ++n;
                        } else {
                            ba[n++] = 63;
                            i = length;
                        }
                    } else if (c == '+') {
                        ba[n++] = 32;
                        ++i;
                    } else {
                        ba[n++] = (byte)c;
                        ++i;
                    }
                    if (i >= length) break;
                    c = encoded.charAt(offset + i);
                }
                --i;
                String s2 = new String(ba, 0, n, charset);
                buffer.append(s2, 0, s2.length());
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        if (buffer == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        try {
            return buffer.build();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static char decodeHexChar(int hi, int lo) {
        try {
            return (char)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not valid encoding '%" + (char)hi + (char)lo + "'");
        }
    }

    public static byte decodeHexByte(char hi, char lo) {
        try {
            return (byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not valid encoding '%" + hi + lo + "'");
        }
    }

    private static void decodeHexByteTo(Utf8StringBuilder buffer, char hi, char lo) {
        buffer.append((byte)((TypeUtil.convertHexDigit(hi) << 4) + TypeUtil.convertHexDigit(lo)));
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    public static String encodeString(String string, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = string.getBytes(charset);
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (byte b : bytes) {
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 45 || b == 46 || b == 95 || b == 126) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        return new String(encoded, 0, n, charset);
    }

    static {
        Charset encoding;
        LOG = LoggerFactory.getLogger(UrlEncoded.class);
        String charset = null;
        try {
            charset = System.getProperty("com.dataiku.dss.shadelib.org.eclipse.jetty.util.UrlEncoding.charset");
            encoding = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
        }
        catch (Exception e) {
            LOG.warn("Unable to set default UrlEncoding charset: {}", (Object)charset, (Object)e);
            encoding = StandardCharsets.UTF_8;
        }
        ENCODING = encoding;
    }
}

