/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.Frame;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.Session;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.WebSocketContainer;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.WebSocket;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.exceptions.InvalidWebSocketException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandlerMetadata;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.internal.ByteBufferMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.internal.PartialByteBufferMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.InputStreamMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.PartialStringMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.ReaderMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.StringMessageSink;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.util.InvokerUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.util.ReflectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JettyWebSocketFrameHandlerFactory
extends ContainerLifeCycle {
    private static final InvokerUtils.Arg[] textCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required()};
    private static final InvokerUtils.Arg[] binaryBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Callback.class).required()};
    private static final InvokerUtils.Arg[] inputStreamCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(InputStream.class).required()};
    private static final InvokerUtils.Arg[] readerCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(Reader.class).required()};
    private static final InvokerUtils.Arg[] textPartialCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
    private static final InvokerUtils.Arg[] binaryPartialBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required(), new InvokerUtils.Arg(Callback.class).required()};
    private final WebSocketContainer container;
    private final WebSocketComponents components;
    private final Map<Class<?>, JettyWebSocketFrameHandlerMetadata> metadataMap = new ConcurrentHashMap();

    public JettyWebSocketFrameHandlerFactory(WebSocketContainer container, WebSocketComponents components) {
        this.container = container;
        this.components = components;
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }

    public JettyWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass) {
        JettyWebSocketFrameHandlerMetadata metadata = this.metadataMap.get(endpointClass);
        if (metadata == null) {
            metadata = this.createMetadata(endpointClass);
            this.metadataMap.put(endpointClass, metadata);
        }
        return metadata;
    }

    public JettyWebSocketFrameHandlerMetadata createMetadata(Class<?> endpointClass) {
        if (Session.Listener.class.isAssignableFrom(endpointClass)) {
            return this.createListenerMetadata(endpointClass);
        }
        WebSocket websocket = endpointClass.getAnnotation(WebSocket.class);
        if (websocket != null) {
            return this.createAnnotatedMetadata(websocket, endpointClass);
        }
        throw new InvalidWebSocketException("Unrecognized WebSocket endpoint: " + endpointClass.getName());
    }

    public JettyWebSocketFrameHandler newJettyFrameHandler(Object endpointInstance) {
        JettyWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpointInstance.getClass());
        this.components.getObjectFactory().decorate(endpointInstance);
        return new JettyWebSocketFrameHandler(this.container, endpointInstance, metadata);
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + String.valueOf(method), e);
        }
    }

    private JettyWebSocketFrameHandlerMetadata createListenerMetadata(Class<?> endpointClass) {
        Method closeMethod;
        Method errorMethod;
        Method binaryMethod;
        Method textMethod;
        Method partialBinaryMethod;
        Method partialTextMethod;
        Method pongMethod;
        Method pingMethod;
        Method frameMethod;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        metadata.setAutoDemand(Session.Listener.AutoDemanding.class.isAssignableFrom(endpointClass));
        MethodHandles.Lookup lookup = JettyWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method openMethod = this.findMethod(endpointClass, "onWebSocketOpen", Session.class);
        if (openMethod != null) {
            MethodHandle connectHandle = this.toMethodHandle(lookup, openMethod);
            metadata.setOpenHandle(connectHandle, openMethod);
        }
        if ((frameMethod = this.findMethod(endpointClass, "onWebSocketFrame", Frame.class, Callback.class)) != null) {
            MethodHandle frameHandle = this.toMethodHandle(lookup, frameMethod);
            metadata.setFrameHandle(frameHandle, frameMethod);
        }
        if ((pingMethod = this.findMethod(endpointClass, "onWebSocketPing", ByteBuffer.class)) != null) {
            MethodHandle pingHandle = this.toMethodHandle(lookup, pingMethod);
            metadata.setPingHandle(pingHandle, pingMethod);
        }
        if ((pongMethod = this.findMethod(endpointClass, "onWebSocketPong", ByteBuffer.class)) != null) {
            MethodHandle pongHandle = this.toMethodHandle(lookup, pongMethod);
            metadata.setPongHandle(pongHandle, pongMethod);
        }
        if ((partialTextMethod = this.findMethod(endpointClass, "onWebSocketPartialText", String.class, Boolean.TYPE)) != null) {
            MethodHandle partialTextHandle = this.toMethodHandle(lookup, partialTextMethod);
            metadata.setTextHandle(PartialStringMessageSink.class, partialTextHandle, partialTextMethod);
        }
        if ((partialBinaryMethod = this.findMethod(endpointClass, "onWebSocketPartialBinary", ByteBuffer.class, Boolean.TYPE, Callback.class)) != null) {
            MethodHandle partialBinaryHandle = this.toMethodHandle(lookup, partialBinaryMethod);
            metadata.setBinaryHandle(PartialByteBufferMessageSink.class, partialBinaryHandle, partialBinaryMethod);
        }
        if ((textMethod = this.findMethod(endpointClass, "onWebSocketText", String.class)) != null) {
            MethodHandle textHandle = this.toMethodHandle(lookup, textMethod);
            metadata.setTextHandle(StringMessageSink.class, textHandle, textMethod);
        }
        if ((binaryMethod = this.findMethod(endpointClass, "onWebSocketBinary", ByteBuffer.class, Callback.class)) != null) {
            MethodHandle binaryHandle = this.toMethodHandle(lookup, binaryMethod);
            metadata.setBinaryHandle(ByteBufferMessageSink.class, binaryHandle, binaryMethod);
        }
        if ((errorMethod = this.findMethod(endpointClass, "onWebSocketError", Throwable.class)) != null) {
            MethodHandle errorHandle = this.toMethodHandle(lookup, errorMethod);
            metadata.setErrorHandle(errorHandle, errorMethod);
        }
        if ((closeMethod = this.findMethod(endpointClass, "onWebSocketClose", Integer.TYPE, String.class)) != null) {
            MethodHandle closeHandle = this.toMethodHandle(lookup, closeMethod);
            metadata.setCloseHandle(closeHandle, closeMethod);
        }
        return metadata;
    }

    private Method findMethod(Class<?> klass, String name, Class<?> ... parameters) {
        Method method = ReflectUtils.findMethod(klass, name, parameters);
        if (method == null) {
            return null;
        }
        if (this.isOverridden(method)) {
            return method;
        }
        return null;
    }

    private boolean isOverridden(Method method) {
        return method.getDeclaringClass() != Session.Listener.class;
    }

    private JettyWebSocketFrameHandlerMetadata createAnnotatedMetadata(WebSocket anno, Class<?> endpointClass) {
        Method[] onMessages;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        JettyWebSocketFrameHandlerMetadata metadata = new JettyWebSocketFrameHandlerMetadata();
        metadata.setAutoDemand(anno.autoDemand());
        MethodHandles.Lookup lookup = JettyWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketOpen.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketOpen.class);
            SESSION = new InvokerUtils.Arg(Session.class).required();
            MethodHandle methodHandle2 = InvokerUtils.mutatedInvoker(lookup, endpointClass, onmethod, SESSION);
            metadata.setOpenHandle(methodHandle2, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg STATUS_CODE = new InvokerUtils.Arg(Integer.TYPE);
            InvokerUtils.Arg REASON = new InvokerUtils.Arg(String.class);
            methodHandle = InvokerUtils.mutatedInvoker(lookup, endpointClass, onmethod, SESSION, STATUS_CODE, REASON);
            metadata.setCloseHandle(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            MethodHandle methodHandle3 = InvokerUtils.mutatedInvoker(lookup, endpointClass, onmethod, SESSION, CAUSE);
            metadata.setErrorHandle(methodHandle3, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnWebSocketFrame.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnWebSocketFrame.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg FRAME = new InvokerUtils.Arg(Frame.class).required();
            InvokerUtils.Arg CALLBACK = new InvokerUtils.Arg(Callback.class).required();
            methodHandle = InvokerUtils.mutatedInvoker(lookup, endpointClass, onmethod, SESSION, FRAME, CALLBACK);
            metadata.setFrameHandle(methodHandle, onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnWebSocketMessage.class)) != null) {
            for (Method onMsg : onMessages) {
                this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                MethodHandle methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, textCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(StringMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, binaryBufferCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(ByteBufferMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, inputStreamCallingArgs);
                if (methodHandle4 != null) {
                    if (!metadata.isAutoDemand()) {
                        throw new InvalidWebSocketException("InputStream methods require auto-demanding WebSocket endpoints");
                    }
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(InputStreamMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, readerCallingArgs);
                if (methodHandle4 != null) {
                    if (!metadata.isAutoDemand()) {
                        throw new InvalidWebSocketException("Reader methods require auto-demanding WebSocket endpoints");
                    }
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(ReaderMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, textPartialCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setTextHandle(PartialStringMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                methodHandle4 = InvokerUtils.optionalMutatedInvoker(lookup, endpointClass, onMsg, binaryPartialBufferCallingArgs);
                if (methodHandle4 != null) {
                    this.assertSignatureValid(endpointClass, onMsg, OnWebSocketMessage.class);
                    metadata.setBinaryHandle(PartialByteBufferMessageSink.class, methodHandle4, onMsg);
                    continue;
                }
                throw InvalidSignatureException.build(endpointClass, OnWebSocketMessage.class, onMsg);
            }
        }
        return metadata;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append(err, endpointClass, method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("@").append(annotationClass.getSimpleName());
        err.append(" return must be void: ");
        ReflectUtils.append(err, endpointClass, method);
        throw new InvalidSignatureException(err.toString());
    }

    public static MethodHandles.Lookup getServerMethodHandleLookup() {
        return MethodHandles.lookup();
    }

    public static MethodHandles.Lookup getApplicationMethodHandleLookup(Class<?> lookupClass) {
        return MethodHandles.publicLookup().in(lookupClass);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, this.metadataMap);
    }
}

