/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ByteBufferCallbackAccumulator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.BufferUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.CoreSession;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.Frame;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.messages.AbstractMessageSink;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

public class ByteArrayMessageSink
extends AbstractMessageSink {
    private ByteBufferCallbackAccumulator accumulator;

    public ByteArrayMessageSink(CoreSession session, MethodHandle methodHandle, boolean autoDemand) {
        super(session, methodHandle, autoDemand);
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        if (methodHandle.type().changeReturnType(Void.TYPE) != onMessageType.changeReturnType(Void.TYPE)) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            long size = (this.accumulator == null ? 0 : this.accumulator.getLength()) + frame.getPayloadLength();
            long maxSize = this.getCoreSession().getMaxBinaryMessageSize();
            if (maxSize > 0L && size > maxSize) {
                callback.failed(new MessageTooLargeException(String.format("Binary message too large: %,d > %,d", size, maxSize)));
                return;
            }
            ByteBuffer payload = frame.getPayload();
            if (frame.isFin() && (this.accumulator == null || this.accumulator.getLength() == 0)) {
                byte[] buf = BufferUtil.toArray(payload);
                this.getMethodHandle().invoke(buf, 0, buf.length);
                callback.succeeded();
                this.autoDemand();
                return;
            }
            if (!frame.isFin() && !frame.hasPayload()) {
                callback.succeeded();
                this.getCoreSession().demand();
                return;
            }
            if (this.accumulator == null) {
                this.accumulator = new ByteBufferCallbackAccumulator();
            }
            this.accumulator.addEntry(payload, callback);
            if (frame.isFin()) {
                callback = Callback.NOOP;
                byte[] buf = this.accumulator.takeByteArray();
                this.getMethodHandle().invoke(buf, 0, buf.length);
                this.autoDemand();
            } else {
                this.getCoreSession().demand();
            }
        }
        catch (Throwable t2) {
            this.fail(t2);
            callback.failed(t2);
        }
    }

    @Override
    public void fail(Throwable failure) {
        if (this.accumulator != null) {
            this.accumulator.fail(failure);
        }
    }
}

