/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow.tracking;

import com.dataiku.dss.shadelib.org.mlflow.api.proto.Service;
import com.dataiku.dss.shadelib.org.mlflow.tracking.EmptyPage;
import com.dataiku.dss.shadelib.org.mlflow.tracking.MlflowClient;
import com.dataiku.dss.shadelib.org.mlflow.tracking.Page;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ExperimentsPage
implements Page<Service.Experiment> {
    private final String token;
    private final List<Service.Experiment> experiments;
    private final MlflowClient client;
    private final String searchFilter;
    private final Service.ViewType experimentViewType;
    private final List<String> orderBy;
    private final int maxResults;

    ExperimentsPage(List<Service.Experiment> experiments, String token, String searchFilter, Service.ViewType experimentViewType, int maxResults, List<String> orderBy, MlflowClient client) {
        this.experiments = Collections.unmodifiableList(experiments);
        this.token = token;
        this.searchFilter = searchFilter;
        this.experimentViewType = experimentViewType;
        this.orderBy = orderBy;
        this.maxResults = maxResults;
        this.client = client;
    }

    @Override
    public int getPageSize() {
        return this.experiments.size();
    }

    @Override
    public boolean hasNextPage() {
        return this.token != null && this.token != "";
    }

    @Override
    public Optional<String> getNextPageToken() {
        if (this.hasNextPage()) {
            return Optional.of(this.token);
        }
        return Optional.empty();
    }

    @Override
    public Page<Service.Experiment> getNextPage() {
        if (this.hasNextPage()) {
            return this.client.searchExperiments(this.searchFilter, this.experimentViewType, this.maxResults, this.orderBy, this.token);
        }
        return new EmptyPage<Service.Experiment>();
    }

    @Override
    public List<Service.Experiment> getItems() {
        return this.experiments;
    }
}

