/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpHost;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequest;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.ProtocolException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.protocol.HttpClientContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.SchemePortResolver;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.UnsupportedSchemeException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.routing.HttpRoute;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.routing.HttpRoutePlanner;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn.DefaultSchemePortResolver;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

