/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.api.v1.params;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.projectnessie.api.v1.params.AbstractParams;
import com.dataiku.dss.shadelib.org.projectnessie.api.v1.params.ReferencesParamsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.model.FetchOption;
import java.util.Objects;
import java.util.StringJoiner;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;

public class ReferencesParams
extends AbstractParams<ReferencesParams> {
    @Parameter(description="Specify how much information to be returned. Will fetch additional metadata for references if set to 'ALL'.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetch")
    @jakarta.ws.rs.QueryParam(value="fetch")
    @Nullable
    @jakarta.annotation.Nullable
    private FetchOption fetchOption;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are:\n\n- ref (Reference) describes the reference, with fields name (String), hash (String), metadata (ReferenceMetadata)\n\n- metadata (ReferenceMetadata) shortcut to ref.metadata, never null, but possibly empty\n\n- commit (CommitMeta) - shortcut to ref.metadata.commitMetaOfHEAD, never null, but possibly empty\n\n- refType (String) - the reference type, either BRANCH or TAG\n\nNote that the expression can only test attributes metadata and commit, if 'fetchOption' is set to 'ALL'.", examples={@ExampleObject(ref="expr_by_refType"), @ExampleObject(ref="expr_by_ref_name"), @ExampleObject(ref="expr_by_ref_commit")})
    @QueryParam(value="filter")
    @jakarta.ws.rs.QueryParam(value="filter")
    @Nullable
    @jakarta.annotation.Nullable
    private String filter;

    public ReferencesParams() {
    }

    @Builder.Constructor
    ReferencesParams(@Nullable @jakarta.annotation.Nullable Integer maxRecords, @Nullable @jakarta.annotation.Nullable String pageToken, @Nullable @jakarta.annotation.Nullable FetchOption fetchOption, @Nullable @jakarta.annotation.Nullable String filter) {
        super(maxRecords, pageToken);
        this.fetchOption = fetchOption;
        this.filter = filter;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String filter() {
        return this.filter;
    }

    public static ReferencesParamsBuilder builder() {
        return new ReferencesParamsBuilder();
    }

    public static ReferencesParams empty() {
        return ReferencesParams.builder().build();
    }

    @Override
    public ReferencesParams forNextPage(String pageToken) {
        return new ReferencesParams(this.maxRecords(), pageToken, this.fetchOption, this.filter);
    }

    public String toString() {
        return new StringJoiner(", ", ReferencesParams.class.getSimpleName() + "[", "]").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("fetchOption=" + String.valueOf((Object)this.fetchOption)).add("filter=" + this.filter).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferencesParams)) {
            return false;
        }
        ReferencesParams that = (ReferencesParams)o;
        return Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && this.fetchOption == that.fetchOption && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxRecords(), this.pageToken(), this.fetchOption, this.filter});
    }
}

