/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.api.v2.params;

import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.projectnessie.api.v2.params.EntriesParams;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="com.dataiku.dss.shadelib.org.projectnessie.api.v2.params.EntriesParams", generator="Immutables")
@NotThreadSafe
public final class EntriesParamsBuilder {
    private Integer maxRecords;
    private String pageToken;
    private ContentKey minKey;
    private ContentKey maxKey;
    private ContentKey prefixKey;
    private List<ContentKey> requestedKeys = null;
    private String filter;
    private Boolean withContent;

    public final EntriesParamsBuilder maxRecords(@Nullable Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public final EntriesParamsBuilder pageToken(@Nullable String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    public final EntriesParamsBuilder minKey(@Nullable ContentKey minKey) {
        this.minKey = minKey;
        return this;
    }

    public final EntriesParamsBuilder maxKey(@Nullable ContentKey maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    public final EntriesParamsBuilder prefixKey(@Nullable ContentKey prefixKey) {
        this.prefixKey = prefixKey;
        return this;
    }

    public final EntriesParamsBuilder addRequestedKeys(ContentKey element) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        return this;
    }

    public final EntriesParamsBuilder addRequestedKeys(ContentKey ... elements) {
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey element : elements) {
            this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
        }
        return this;
    }

    public final EntriesParamsBuilder requestedKeys(@Nullable Iterable<? extends ContentKey> elements) {
        if (elements == null) {
            this.requestedKeys = null;
            return this;
        }
        this.requestedKeys = new ArrayList<ContentKey>();
        return this.addAllRequestedKeys(elements);
    }

    public final EntriesParamsBuilder addAllRequestedKeys(Iterable<? extends ContentKey> elements) {
        Objects.requireNonNull(elements, "requestedKeys element");
        if (this.requestedKeys == null) {
            this.requestedKeys = new ArrayList<ContentKey>();
        }
        for (ContentKey contentKey : elements) {
            this.requestedKeys.add(Objects.requireNonNull(contentKey, "requestedKeys element"));
        }
        return this;
    }

    public final EntriesParamsBuilder filter(@Nullable String filter) {
        this.filter = filter;
        return this;
    }

    public final EntriesParamsBuilder withContent(@Nullable Boolean withContent) {
        this.withContent = withContent;
        return this;
    }

    public EntriesParams build() {
        return new EntriesParams(this.maxRecords, this.pageToken, this.minKey, this.maxKey, this.prefixKey, this.requestedKeys == null ? null : EntriesParamsBuilder.createUnmodifiableList(true, this.requestedKeys), this.filter, this.withContent);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

