/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.api.ns;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetNamespaceResult;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.builder.BaseGetNamespaceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.error.ContentKeyErrorDetails;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieContentNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;

public final class ClientSideGetNamespace
extends BaseGetNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideGetNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public Namespace get() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.getWithResponse().getNamespace();
    }

    @Override
    public GetNamespaceResult getWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = this.namespace.toContentKey();
        try {
            ContentResponse contentResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).getSingle(key);
            Content c = contentResponse.getContent();
            if (!(c instanceof Namespace)) {
                throw new NessieNamespaceNotFoundException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Namespace '%s' does not exist", key.toCanonicalString()));
            }
            return GetNamespaceResult.of((Namespace)c, contentResponse.getEffectiveReference());
        }
        catch (NessieContentNotFoundException e) {
            throw new NessieNamespaceNotFoundException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Namespace '%s' does not exist", key.toCanonicalString()));
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
    }
}

