/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth;

import com.dataiku.dss.shadelib.org.projectnessie.client.auth.NessieAuthentication;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.NessieAuthenticationProvider;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpAuthentication;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.RequestContext;
import java.util.Objects;
import java.util.function.Function;

public class BearerAuthenticationProvider
implements NessieAuthenticationProvider {
    public static final String AUTH_TYPE_VALUE = "BEARER";

    @Override
    public String getAuthTypeValue() {
        return AUTH_TYPE_VALUE;
    }

    @Override
    public NessieAuthentication build(Function<String, String> configSupplier) {
        return BearerAuthenticationProvider.create(configSupplier.apply("nessie.authentication.token"));
    }

    public static HttpAuthentication create(String token) {
        return new BearerAuthentication(token);
    }

    private static class BearerAuthentication
    implements HttpAuthentication {
        private final String authHeaderValue;

        private BearerAuthentication(String token) {
            Objects.requireNonNull(token, "Token must not be null for authentication type BEARER");
            this.authHeaderValue = "Bearer " + token;
        }

        @Override
        public void applyToHttpClient(HttpClient.Builder client) {
            client.addRequestFilter(this::applyToHttpRequest);
        }

        @Override
        public void applyToHttpRequest(RequestContext context) {
            context.putHeader("Authorization", this.authHeaderValue);
        }
    }
}

