/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonCreator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonProperty;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.DeviceCodeTokenRequest;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.GrantType;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.PublicClientRequest;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenRequestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeTokenRequest", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeTokenRequest
implements DeviceCodeTokenRequest {
    @Nullable
    private final String scope;
    private final Map<String, String> extraParameters;
    @Nullable
    private final String clientId;
    private final transient GrantType grantType;
    private final String deviceCode;

    private ImmutableDeviceCodeTokenRequest(@Nullable String scope, Map<String, String> extraParameters, @Nullable String clientId, String deviceCode) {
        this.scope = scope;
        this.extraParameters = extraParameters;
        this.clientId = clientId;
        this.deviceCode = deviceCode;
        this.grantType = Objects.requireNonNull(DeviceCodeTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, String> extraParameters() {
        return this.extraParameters;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="device_code")
    public String getDeviceCode() {
        return this.deviceCode;
    }

    public final ImmutableDeviceCodeTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(value, this.extraParameters, this.clientId, this.deviceCode);
    }

    public final ImmutableDeviceCodeTokenRequest withExtraParameters(Map<String, ? extends String> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableDeviceCodeTokenRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableDeviceCodeTokenRequest(this.scope, newValue, this.clientId, this.deviceCode);
    }

    public final ImmutableDeviceCodeTokenRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(this.scope, this.extraParameters, value, this.deviceCode);
    }

    public final ImmutableDeviceCodeTokenRequest withDeviceCode(String value) {
        String newValue = Objects.requireNonNull(value, "deviceCode");
        if (this.deviceCode.equals(newValue)) {
            return this;
        }
        return new ImmutableDeviceCodeTokenRequest(this.scope, this.extraParameters, this.clientId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeTokenRequest && this.equalsByValue((ImmutableDeviceCodeTokenRequest)another);
    }

    private boolean equalsByValue(ImmutableDeviceCodeTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters) && Objects.equals(this.clientId, another.clientId) && this.grantType.equals((Object)another.grantType) && this.deviceCode.equals(another.deviceCode);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.extraParameters.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.deviceCode.hashCode();
        return h2;
    }

    public String toString() {
        return "DeviceCodeTokenRequest{scope=" + this.scope + ", extraParameters=" + String.valueOf(this.extraParameters) + ", clientId=" + this.clientId + ", grantType=" + String.valueOf((Object)this.grantType) + ", deviceCode=" + this.deviceCode + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeTokenRequest fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeTokenRequest.builder();
        if (json._scope != null) {
            builder.scope(json._scope);
        }
        if (json._extraParameters != null) {
            builder.putAllExtraParameters(json._extraParameters);
        }
        if (json._clientId != null) {
            builder.clientId(json._clientId);
        }
        if (json._deviceCode != null) {
            builder.deviceCode(json._deviceCode);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeTokenRequest copyOf(DeviceCodeTokenRequest instance) {
        if (instance instanceof ImmutableDeviceCodeTokenRequest) {
            return (ImmutableDeviceCodeTokenRequest)instance;
        }
        return ImmutableDeviceCodeTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DeviceCodeTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements DeviceCodeTokenRequest.Builder {
        private static final long INIT_BIT_DEVICE_CODE = 1L;
        private long initBits = 1L;
        private String scope;
        private Map<String, String> extraParameters = new LinkedHashMap<String, String>();
        private String clientId;
        private String deviceCode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String scopeValue;
            String clientIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof DeviceCodeTokenRequest) {
                instance = (DeviceCodeTokenRequest)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                this.deviceCode(instance.getDeviceCode());
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 4L) == 0L) {
                    this.putAllExtraParameters(instance.extraParameters());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameter(String key, String value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), Objects.requireNonNull(value, value == null ? "extraParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraParameters value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends String> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraParameters value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="device_code")
        @CanIgnoreReturnValue
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = Objects.requireNonNull(deviceCode, "deviceCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableDeviceCodeTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeviceCodeTokenRequest(this.scope, ImmutableDeviceCodeTokenRequest.createUnmodifiableMap(false, false, this.extraParameters), this.clientId, this.deviceCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deviceCode");
            }
            return "Cannot build DeviceCodeTokenRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="DeviceCodeTokenRequest", generator="Immutables")
    static final class Json
    implements DeviceCodeTokenRequest {
        @JsonIgnore
        String _scope;
        @JsonIgnore
        String _clientId;
        @JsonIgnore
        String _deviceCode;
        @JsonIgnore
        final Map<String, String> _extraParameters = new HashMap<String, String>();

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this._scope = scope;
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this._clientId = clientId;
        }

        @JsonProperty(value="device_code")
        public void setDeviceCode(String deviceCode) {
            this._deviceCode = deviceCode;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, String value) {
            this._extraParameters.put(key, value);
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> extraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDeviceCode() {
            throw new UnsupportedOperationException();
        }
    }
}

