/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.rest.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public final class CapturingInputStream
extends FilterInputStream {
    static final int CAPTURE_LEN = 2048;
    private final byte[] capture = new byte[2048];
    private int captured;

    public CapturingInputStream(InputStream delegate) {
        super(delegate);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rd = super.read(b, off, len);
        int captureRemain = this.capture.length - this.captured;
        if (rd > 0 && captureRemain > 0) {
            int copy = Math.min(rd, captureRemain);
            System.arraycopy(b, off, this.capture, this.captured, copy);
            this.captured += copy;
        }
        return rd;
    }

    @Override
    public int read() throws IOException {
        int rd = super.read();
        if (rd >= 0 && this.captured < this.capture.length) {
            this.capture[this.captured++] = (byte)rd;
        }
        return rd;
    }

    public String capture() {
        for (int i = 0; i < 2048; ++i) {
            try {
                if (this.read() >= 0) continue;
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.captured();
    }

    public String captured() {
        return new String(this.capture, 0, this.captured, StandardCharsets.UTF_8);
    }
}

