/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.AssignBranchBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.AssignReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.AssignTagBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.CreateReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.DeleteBranchBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.DeleteReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.DeleteTagBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetAllReferencesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetCommitLogBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetDiffBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetEntriesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetRepositoryConfigBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.MergeReferenceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.ReferenceHistoryBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.TransplantCommitsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.UpdateRepositoryConfigBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpAssignBranch;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpAssignReference;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpAssignTag;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpCommitMultipleOperations;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpCreateReference;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpDeleteBranch;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpDeleteReference;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpDeleteTag;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetAllReferences;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetCommitLog;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetContent;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetDiff;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetEntries;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetReference;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpGetRepositoryConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpMergeReference;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpReferenceHistory;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpTransplantCommits;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2.HttpUpdateRepositoryConfig;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Branch;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.NessieConfiguration;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import com.dataiku.dss.shadelib.org.projectnessie.model.SingleReferenceResponse;
import java.util.Arrays;
import java.util.Optional;

public class HttpApiV2
implements NessieApiV2 {
    private final HttpClient client;
    private volatile boolean didGetConfig;
    private volatile boolean isNessieSpec220;

    public HttpApiV2(HttpClient client) {
        this.client = client;
    }

    boolean isNessieSpec220() {
        if (!this.didGetConfig) {
            this.getConfig();
        }
        return this.isNessieSpec220;
    }

    String toPathString(ContentKey key) {
        return this.isNessieSpec220() ? key.toPathStringEscaped() : key.toPathString();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public <C> Optional<C> unwrapClient(Class<C> clientType) {
        return clientType.isAssignableFrom(HttpClient.class) ? Optional.of(clientType.cast(this.client)) : Optional.empty();
    }

    @Override
    public NessieConfiguration getConfig() {
        NessieConfiguration config = this.client.newRequest().path("config").get().readEntity(NessieConfiguration.class);
        this.didGetConfig = true;
        if (config.getSpecVersion() != null) {
            int[] parts = Arrays.stream(config.getSpecVersion().split("[.]")).mapToInt(Integer::parseInt).toArray();
            this.isNessieSpec220 = parts[0] > 2 || parts[0] == 2 && parts[1] >= 2;
        }
        return config;
    }

    @Override
    public Branch getDefaultBranch() throws NessieNotFoundException {
        return (Branch)this.client.newRequest().path("trees/-").unwrap(NessieNotFoundException.class).get().readEntity(SingleReferenceResponse.class).getReference();
    }

    @Override
    public GetContentBuilder getContent() {
        return new HttpGetContent(this.client, this);
    }

    @Override
    public GetAllReferencesBuilder getAllReferences() {
        return new HttpGetAllReferences(this.client);
    }

    @Override
    public CreateReferenceBuilder createReference() {
        return new HttpCreateReference(this.client);
    }

    @Override
    public GetReferenceBuilder getReference() {
        return new HttpGetReference(this.client);
    }

    @Override
    public ReferenceHistoryBuilder referenceHistory() {
        return new HttpReferenceHistory(this.client);
    }

    @Override
    public GetEntriesBuilder getEntries() {
        return new HttpGetEntries(this.client, this);
    }

    @Override
    public GetCommitLogBuilder getCommitLog() {
        return new HttpGetCommitLog(this.client);
    }

    @Override
    @Deprecated
    public AssignTagBuilder assignTag() {
        return new HttpAssignTag(this.client);
    }

    @Override
    @Deprecated
    public DeleteTagBuilder deleteTag() {
        return new HttpDeleteTag(this.client);
    }

    @Override
    @Deprecated
    public AssignBranchBuilder assignBranch() {
        return new HttpAssignBranch(this.client);
    }

    @Override
    @Deprecated
    public DeleteBranchBuilder deleteBranch() {
        return new HttpDeleteBranch(this.client);
    }

    @Override
    public AssignReferenceBuilder<Reference> assignReference() {
        return new HttpAssignReference(this.client);
    }

    @Override
    public DeleteReferenceBuilder<Reference> deleteReference() {
        return new HttpDeleteReference(this.client);
    }

    @Override
    public TransplantCommitsBuilder transplantCommitsIntoBranch() {
        return new HttpTransplantCommits(this.client);
    }

    @Override
    public MergeReferenceBuilder mergeRefIntoBranch() {
        return new HttpMergeReference(this.client);
    }

    @Override
    public CommitMultipleOperationsBuilder commitMultipleOperations() {
        return new HttpCommitMultipleOperations(this.client);
    }

    @Override
    public GetDiffBuilder getDiff() {
        return new HttpGetDiff(this.client, this);
    }

    @Override
    public GetRepositoryConfigBuilder getRepositoryConfig() {
        return new HttpGetRepositoryConfig(this.client);
    }

    @Override
    public UpdateRepositoryConfigBuilder updateRepositoryConfig() {
        return new HttpUpdateRepositoryConfig(this.client);
    }
}

