/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.rest.v2;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetRepositoryConfigBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpRequest;
import com.dataiku.dss.shadelib.org.projectnessie.model.RepositoryConfig;
import com.dataiku.dss.shadelib.org.projectnessie.model.RepositoryConfigResponse;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class HttpGetRepositoryConfig
implements GetRepositoryConfigBuilder {
    private final HttpClient client;
    private final Set<RepositoryConfig.Type> types = new HashSet<RepositoryConfig.Type>();

    HttpGetRepositoryConfig(HttpClient client) {
        this.client = client;
    }

    @Override
    public GetRepositoryConfigBuilder type(RepositoryConfig.Type type) {
        this.types.add(Objects.requireNonNull(type, "repository config type is null"));
        return this;
    }

    @Override
    public RepositoryConfigResponse get() {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("repository config types to retrieve must be set");
        }
        HttpRequest req = this.client.newRequest().path("config/repository");
        this.types.stream().map(RepositoryConfig.Type::name).forEach(t2 -> req.queryParam("type", (String)t2));
        return req.get().readEntity(RepositoryConfigResponse.class);
    }
}

