/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.error;

import com.dataiku.dss.shadelib.org.projectnessie.error.ContentKeyErrorDetails;
import com.dataiku.dss.shadelib.org.projectnessie.error.ErrorCode;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieError;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;

public class NessieContentNotFoundException
extends NessieNotFoundException {
    private final ContentKeyErrorDetails contentKeyErrorDetails;

    public NessieContentNotFoundException(ContentKey key, String ref) {
        super(String.format("Could not find content for key '%s' in reference '%s'.", key, ref));
        this.contentKeyErrorDetails = ContentKeyErrorDetails.contentKeyErrorDetails(key);
    }

    public NessieContentNotFoundException(NessieError error) {
        super(error);
        this.contentKeyErrorDetails = error.getErrorDetailsAsOrNull(ContentKeyErrorDetails.class);
    }

    @Override
    public ErrorCode getErrorCode() {
        return ErrorCode.CONTENT_NOT_FOUND;
    }

    @Override
    public ContentKeyErrorDetails getErrorDetails() {
        return this.contentKeyErrorDetails;
    }
}

