/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonTypeName;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableDetached;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;
import com.dataiku.dss.shadelib.org.projectnessie.model.ReferenceMetadata;
import com.dataiku.dss.shadelib.org.projectnessie.model.Validation;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Pattern;
import javax.validation.constraints.NotEmpty;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Detached commit hash")
@JsonSerialize(as=ImmutableDetached.class)
@JsonDeserialize(as=ImmutableDetached.class)
@JsonTypeName(value="DETACHED")
@Value.Immutable
public interface Detached
extends Reference {
    public static final String REF_NAME = "DETACHED";

    @Override
    @JsonIgnore
    @Value.Redacted
    default public String getName() {
        return REF_NAME;
    }

    @Override
    @NotEmpty
    @jakarta.validation.constraints.NotEmpty
    @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.")
    @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.")
    @Value.Parameter(order=1)
    public @NotEmpty @jakarta.validation.constraints.NotEmpty @javax.validation.constraints.Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}([.][0-9]{1,9})?Z|([0-9]+)))*)$", message="Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.") String getHash();

    @Override
    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    @Value.Parameter(order=2)
    public ReferenceMetadata getMetadata();

    @Override
    @Value.Check
    default public void checkHash() {
        Validation.validateHashOrRelativeSpec(this.getHash());
    }

    @Override
    default public Reference.ReferenceType getType() {
        throw new UnsupportedOperationException("Illegal use of detached reference");
    }

    public static ImmutableDetached.Builder builder() {
        return ImmutableDetached.builder();
    }

    public static Detached of(String hash) {
        return ImmutableDetached.of(hash, null);
    }
}

