/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.org.projectnessie.model.Util;
import java.util.List;

public interface Elements {
    public List<String> getElements();

    public String[] getElementsArray();

    public int getElementCount();

    public static List<String> elementsFromPathString(String encoded) {
        return Util.fromPathString(encoded);
    }

    default public String toPathString() {
        return Util.toPathString(this.getElements());
    }

    default public String toPathStringEscaped() {
        return Util.toPathStringEscaped(this.getElements());
    }

    default public String toCanonicalString() {
        return Util.toCanonicalString(this.getElements());
    }

    default public void validate(String type) {
        List<String> elements = this.getElements();
        int elems = elements.size();
        if (elems > 20) {
            throw new IllegalStateException(String.format("%s too long, max allowed number of elements: %s", type, 20));
        }
        int sum = 0;
        for (int i = 0; i < elems; ++i) {
            String e = elements.get(i);
            if (e == null) {
                throw new IllegalArgumentException(String.format("%s '%s' must not contain a null element", type, elements));
            }
            int l = e.length();
            if (l == 0) {
                throw new IllegalArgumentException(String.format("%s '%s' must not contain an empty element", type, elements));
            }
            for (int j = 0; j < l; ++j) {
                char c = e.charAt(j);
                if (c < ' ') {
                    throw new IllegalArgumentException(String.format("%s '%s' must not contain characters less than 0x%2h", type, elements, 32));
                }
                if (c != '\u007f') continue;
                throw new IllegalArgumentException(String.format("%s '%s' must not contain the character 0x7F", type, elements));
            }
            sum += l;
        }
        if (sum > 500) {
            throw new IllegalStateException(String.format("%s too long, max allowed length: %d", type, 500));
        }
    }
}

