/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableIdentifiedContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableIdentifiedElement;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableIdentifiedContentKey.class)
@JsonDeserialize(as=ImmutableIdentifiedContentKey.class)
@Value.Immutable
public interface IdentifiedContentKey {
    @NotNull
    @jakarta.validation.constraints.NotNull
    @Size
    @jakarta.validation.constraints.Size(min=1)
    public @NotNull @jakarta.validation.constraints.NotNull @Size @jakarta.validation.constraints.Size(min=1) List<IdentifiedElement> elements();

    @NotNull
    @jakarta.validation.constraints.NotNull
    public ContentKey contentKey();

    @JsonIgnore
    @Value.Redacted
    default public IdentifiedElement lastElement() {
        List<IdentifiedElement> el = this.elements();
        return el.get(el.size() - 1);
    }

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public Content.Type type();

    @Value.Check
    default public void check() {
        if (this.contentKey().getElementCount() != this.elements().size()) {
            throw new IllegalArgumentException("Number of content-key elements must match the identified-elements");
        }
    }

    public static ImmutableIdentifiedContentKey.Builder builder() {
        return ImmutableIdentifiedContentKey.builder();
    }

    public static IdentifiedContentKey identifiedContentKeyFromContent(ContentKey key, Content content, Function<List<String>, String> keyToContentId) {
        return IdentifiedContentKey.identifiedContentKeyFromContent(key, content.getType(), content.getId(), keyToContentId);
    }

    public static IdentifiedContentKey identifiedContentKeyFromContent(ContentKey key, Content.Type type, String contentId, Function<List<String>, String> keyToContentId) {
        ImmutableIdentifiedContentKey.Builder identifiedKey = IdentifiedContentKey.builder().contentKey(key).type(type);
        ArrayList<String> path = new ArrayList<String>();
        List<String> keyElements = key.getElements();
        int elementCount = keyElements.size();
        for (int i = 0; i < elementCount - 1; ++i) {
            String element = keyElements.get(i);
            path.add(element);
            String id = keyToContentId.apply(path);
            identifiedKey.addElements(IdentifiedElement.identifiedElement(element, id));
        }
        identifiedKey.addElements(IdentifiedElement.identifiedElement(keyElements.get(elementCount - 1), contentId));
        return identifiedKey.build();
    }

    @JsonSerialize(as=ImmutableIdentifiedElement.class)
    @JsonDeserialize(as=ImmutableIdentifiedElement.class)
    @Value.Immutable
    public static interface IdentifiedElement {
        @Value.Parameter(order=1)
        public String element();

        @com.dataiku.dss.shadelib.javax.annotation.Nullable
        @Nullable
        @Value.Parameter(order=2)
        public String contentId();

        public static IdentifiedElement identifiedElement(String element, String contentId) {
            return ImmutableIdentifiedElement.of(element, contentId);
        }
    }
}

