/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.model;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.annotation.JsonView;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dataiku.dss.shadelib.org.projectnessie.model.Conflict;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableContentKeyDetails;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableMergeResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.LogResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.MergeBehavior;
import com.dataiku.dss.shadelib.org.projectnessie.model.ser.Views;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Merge Response")
@JsonSerialize(as=ImmutableMergeResponse.class)
@JsonDeserialize(as=ImmutableMergeResponse.class)
@Value.Immutable
public interface MergeResponse {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public String getResultantTargetHash();

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public String getCommonAncestor();

    public String getTargetBranch();

    public String getEffectiveTargetHash();

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    public String getExpectedHash();

    @Deprecated
    @Schema(deprecated=true, hidden=true)
    @JsonView(value={Views.V1.class})
    public List<LogResponse.LogEntry> getSourceCommits();

    @com.dataiku.dss.shadelib.javax.annotation.Nullable
    @Nullable
    @Deprecated
    @Schema(deprecated=true, hidden=true)
    @JsonView(value={Views.V1.class})
    public List<LogResponse.LogEntry> getTargetCommits();

    public List<ContentKeyDetails> getDetails();

    @Deprecated
    public static enum ContentKeyConflict {
        NONE,
        UNRESOLVABLE;


        public static ContentKeyConflict parse(String mergeBehavior) {
            try {
                if (mergeBehavior != null) {
                    return ContentKeyConflict.valueOf(mergeBehavior.toUpperCase(Locale.ROOT));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return UNRESOLVABLE;
            }
        }

        static final class Deserializer
        extends JsonDeserializer<ContentKeyConflict> {
            Deserializer() {
            }

            @Override
            public ContentKeyConflict deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String name = p.readValueAs(String.class);
                return name != null ? ContentKeyConflict.parse(name) : null;
            }
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Merge Per-Content-Key details")
    @JsonSerialize(as=ImmutableContentKeyDetails.class)
    @JsonDeserialize(as=ImmutableContentKeyDetails.class)
    @Value.Immutable
    public static interface ContentKeyDetails {
        public ContentKey getKey();

        public MergeBehavior getMergeBehavior();

        @Deprecated
        @JsonDeserialize(using=ContentKeyConflict.Deserializer.class)
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        @Value.Default
        default public ContentKeyConflict getConflictType() {
            return ContentKeyConflict.NONE;
        }

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        public List<String> getSourceCommits();

        @Deprecated
        @Schema(deprecated=true, hidden=true)
        @JsonView(value={Views.V1.class})
        public List<String> getTargetCommits();

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonView(value={Views.V2.class})
        @com.dataiku.dss.shadelib.javax.annotation.Nullable
        @Nullable
        public Conflict getConflict();
    }
}

