/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.util.Formattable;
import java.util.Formatter;
import javax.measure.Prefix;
import javax.measure.UnitConverter;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.spi.NumberSystem;

class ConverterFormatter {
    private static final String LOCAL_FORMAT_PATTERN = "%s";

    ConverterFormatter() {
    }

    static int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer, SymbolMap symbolMap) {
        if (converter instanceof AddConverter) {
            return ConverterFormatter.additionPrecedence((AddConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof LogConverter) {
            return ConverterFormatter.exponentPrecedenceLogConveter((LogConverter)converter, buffer);
        }
        if (converter instanceof ExpConverter) {
            return ConverterFormatter.exponentPrecedenceExpConveter((ExpConverter)converter, unitPrecedence, buffer);
        }
        if (converter instanceof MultiplyConverter && !(converter instanceof PowerOfIntConverter)) {
            return ConverterFormatter.productPrecedence((MultiplyConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof PowerOfIntConverter) {
            Prefix prefix = symbolMap.getPrefix(converter);
            if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
                return ConverterFormatter.noopPrecedence(buffer, symbolMap, prefix);
            }
            return ConverterFormatter.productPrecedence((PowerOfIntConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof AbstractConverter.Pair) {
            AbstractConverter.Pair pair = (AbstractConverter.Pair)converter;
            if (pair.getLeft() == AbstractConverter.IDENTITY) {
                return ConverterFormatter.formatConverter(pair.getRight(), true, unitPrecedence, buffer, symbolMap);
            }
            if (pair.getLeft() instanceof Formattable) {
                return ConverterFormatter.formatFormattable((Formattable)pair.getLeft(), unitPrecedence, buffer);
            }
            if (pair.getRight() instanceof Formattable) {
                return ConverterFormatter.formatFormattable((Formattable)pair.getRight(), unitPrecedence, buffer);
            }
            return ConverterFormatter.formatConverter(pair.getLeft(), true, unitPrecedence, buffer, symbolMap);
        }
        if (converter != null) {
            buffer.replace(0, 1, converter.toString());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unable to format, no UnitConverter given");
    }

    private static int productPrecedence(PowerOfIntConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        PowerOfIntConverter powerConverter;
        if (unitPrecedence < 2) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if (!(powerConverter = converter).isIdentity()) {
            if (continued) {
                buffer.append('\u00b7');
            }
            buffer.append(powerConverter.getBase()).append("^").append(powerConverter.getExponent());
        }
        return 2;
    }

    private static int productPrecedence(MultiplyConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        Number factor;
        if (unitPrecedence < 2) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if ((factor = converter.getFactor()) instanceof RationalNumber) {
            RationalNumber rational = (RationalNumber)factor;
            if (continued) {
                if (rational.isInteger()) {
                    buffer.append('\u00b7');
                    buffer.append(rational.toString());
                } else {
                    RationalNumber reciprocal = rational.reciprocal();
                    if (reciprocal.isInteger()) {
                        buffer.append('/');
                        buffer.append(reciprocal.toString());
                    } else {
                        buffer.append('\u00b7');
                        buffer.append(rational.toRationalString('/'));
                    }
                }
            } else {
                buffer.append(rational.toRationalString('/'));
            }
        } else {
            if (continued) {
                buffer.append('\u00b7');
            }
            buffer.append(String.valueOf(factor));
        }
        return 2;
    }

    private static int exponentPrecedenceExpConveter(ExpConverter converter, int unitPrecedence, StringBuilder buffer) {
        if (unitPrecedence < 4) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        StringBuilder expr = new StringBuilder();
        double base = converter.getBase();
        if (base == Math.E) {
            expr.append('e');
        } else {
            expr.append((int)base);
        }
        expr.append('^');
        buffer.insert(0, expr);
        return 4;
    }

    private static int exponentPrecedenceLogConveter(LogConverter converter, StringBuilder buffer) {
        double base = converter.getBase();
        StringBuilder expr = new StringBuilder();
        if (base == Math.E) {
            expr.append("ln");
        } else {
            expr.append("log");
            if (base != 10.0) {
                expr.append((int)base);
            }
        }
        expr.append("(");
        buffer.insert(0, expr);
        buffer.append(")");
        return 4;
    }

    private static int additionPrecedence(AddConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        Number offset;
        NumberSystem ns;
        if (unitPrecedence < 0) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if ((ns = Calculus.currentNumberSystem()).compare(offset = converter.getOffset(), 0) < 0) {
            buffer.append("-");
            offset = ns.negate(offset);
        } else if (continued) {
            buffer.append("+");
        }
        buffer.append(offset);
        return 0;
    }

    private static int noopPrecedence(StringBuilder buffer, SymbolMap symbolMap, Prefix prefix) {
        buffer.insert(0, symbolMap.getSymbol(prefix));
        return Integer.MAX_VALUE;
    }

    private static int formatFormattable(Formattable f, int unitPrecedence, StringBuilder buffer) {
        Formatter fmt = new Formatter();
        fmt.format(LOCAL_FORMAT_PATTERN, f);
        buffer.replace(0, 1, fmt.toString());
        fmt.close();
        return unitPrecedence;
    }

    static int formatConverterLocal(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer, SymbolMap symbolMap) {
        Prefix prefix = symbolMap.getPrefix(converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            buffer.insert(0, symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        if (converter instanceof AddConverter) {
            Number offset;
            NumberSystem ns;
            if (unitPrecedence < 0) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((ns = Calculus.currentNumberSystem()).compare(offset = ((AddConverter)converter).getOffset(), 0) < 0) {
                buffer.append("-");
                offset = ns.negate(offset);
            } else if (continued) {
                buffer.append("+");
            }
            buffer.append(offset);
            return 0;
        }
        if (converter instanceof MultiplyConverter) {
            Number factor;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (continued) {
                buffer.append('\u00b7');
            }
            if ((factor = ((MultiplyConverter)converter).getFactor()) instanceof RationalNumber) {
                RationalNumber rational = (RationalNumber)factor;
                buffer.append(rational.toRationalString('/'));
            } else {
                buffer.append(factor);
            }
            return 2;
        }
        buffer.insert(0, converter.toString() + "(");
        buffer.append(")");
        return 4;
    }
}

