/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.dictionary;

import com.databricks.internal.apache.arrow.vector.FieldVector;
import com.databricks.internal.apache.arrow.vector.compare.VectorEqualsVisitor;
import com.databricks.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import java.util.Objects;

public class Dictionary {
    private final DictionaryEncoding encoding;
    private final FieldVector dictionary;

    public Dictionary(FieldVector dictionary, DictionaryEncoding encoding) {
        this.dictionary = dictionary;
        this.encoding = encoding;
    }

    public FieldVector getVector() {
        return this.dictionary;
    }

    public DictionaryEncoding getEncoding() {
        return this.encoding;
    }

    public ArrowType getVectorType() {
        return this.dictionary.getField().getType();
    }

    public String toString() {
        return "Dictionary " + this.encoding + " " + this.dictionary;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dictionary)) {
            return false;
        }
        Dictionary that = (Dictionary)o;
        if (!Objects.equals(this.encoding, that.encoding)) return false;
        new VectorEqualsVisitor();
        if (!VectorEqualsVisitor.vectorEquals(that.dictionary, this.dictionary)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.dictionary);
    }
}

