/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.http.protocol;

import com.databricks.internal.apache.http.HttpException;
import com.databricks.internal.apache.http.HttpRequest;
import com.databricks.internal.apache.http.HttpRequestInterceptor;
import com.databricks.internal.apache.http.annotation.Contract;
import com.databricks.internal.apache.http.annotation.ThreadingBehavior;
import com.databricks.internal.apache.http.params.HttpParams;
import com.databricks.internal.apache.http.protocol.HttpContext;
import com.databricks.internal.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s2 = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s2 = (String)params.getParameter("http.useragent");
            }
            if (s2 == null) {
                s2 = this.userAgent;
            }
            if (s2 != null) {
                request.addHeader("User-Agent", s2);
            }
        }
    }
}

