/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms.bc;

import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.KeyTransRecipient;
import com.databricks.internal.bouncycastle.cms.bc.CMSUtils;
import com.databricks.internal.bouncycastle.crypto.CipherParameters;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.operator.OperatorException;
import com.databricks.internal.bouncycastle.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.recipientKey = asymmetricKeyParameter;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper bcRSAAsymmetricKeyUnwrapper = new BcRSAAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getBcKey(bcRSAAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

