/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.operator.bc;

import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.databricks.internal.bouncycastle.crypto.ExtendedDigest;
import com.databricks.internal.bouncycastle.crypto.Signer;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.crypto.signers.DSADigestSigner;
import com.databricks.internal.bouncycastle.crypto.signers.DSASigner;
import com.databricks.internal.bouncycastle.crypto.util.PublicKeyFactory;
import com.databricks.internal.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.databricks.internal.bouncycastle.operator.OperatorCreationException;
import com.databricks.internal.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

