/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.crypto.cmce;

import com.databricks.internal.bouncycastle.math.raw.Interleave;
import com.databricks.internal.bouncycastle.pqc.crypto.cmce.GF;

final class GF13
extends GF {
    GF13() {
    }

    @Override
    protected void gf_mul_poly(int n, int[] nArray, short[] sArray, short[] sArray2, short[] sArray3, int[] nArray2) {
        short s2;
        short s3;
        int n2;
        nArray2[0] = this.gf_mul_ext(sArray2[0], sArray3[0]);
        for (n2 = 1; n2 < n; ++n2) {
            nArray2[n2 + n2 - 1] = 0;
            s3 = sArray2[n2];
            s2 = sArray3[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = n2 + i;
                nArray2[n3] = nArray2[n3] ^ this.gf_mul_ext_par(s3, sArray3[i], sArray2[i], s2);
            }
            nArray2[n2 + n2] = this.gf_mul_ext(s3, s2);
        }
        for (n2 = (n - 1) * 2; n2 >= n; --n2) {
            s3 = nArray2[n2];
            for (s2 = 0; s2 < nArray.length; ++s2) {
                int n4 = n2 - n + nArray[s2];
                nArray2[n4] = nArray2[n4] ^ s3;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            sArray[n2] = this.gf_reduce(nArray2[n2]);
        }
    }

    @Override
    protected void gf_sqr_poly(int n, int[] nArray, short[] sArray, short[] sArray2, int[] nArray2) {
        int n2;
        nArray2[0] = this.gf_sq_ext(sArray2[0]);
        for (n2 = 1; n2 < n; ++n2) {
            nArray2[n2 + n2 - 1] = 0;
            nArray2[n2 + n2] = this.gf_sq_ext(sArray2[n2]);
        }
        for (n2 = (n - 1) * 2; n2 >= n; --n2) {
            int n3 = nArray2[n2];
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = n2 - n + nArray[i];
                nArray2[n4] = nArray2[n4] ^ n3;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            sArray[n2] = this.gf_reduce(nArray2[n2]);
        }
    }

    @Override
    protected short gf_frac(short s2, short s3) {
        short s4 = this.gf_sqmul(s2, s2);
        short s5 = this.gf_sq2mul(s4, s4);
        short s6 = this.gf_sq2(s5);
        s6 = this.gf_sq2mul(s6, s5);
        s6 = this.gf_sq2(s6);
        s6 = this.gf_sq2mul(s6, s5);
        return this.gf_sqmul(s6, s3);
    }

    @Override
    protected short gf_inv(short s2) {
        return this.gf_frac(s2, (short)1);
    }

    @Override
    protected short gf_mul(short s2, short s3) {
        short s4 = s2;
        short s5 = s3;
        int n = s4 * (s5 & 1);
        for (int i = 1; i < 13; ++i) {
            n ^= s4 * (s5 & 1 << i);
        }
        return this.gf_reduce(n);
    }

    @Override
    protected int gf_mul_ext(short s2, short s3) {
        short s4 = s2;
        short s5 = s3;
        int n = s4 * (s5 & 1);
        for (int i = 1; i < 13; ++i) {
            n ^= s4 * (s5 & 1 << i);
        }
        return n;
    }

    private int gf_mul_ext_par(short s2, short s3, short s4, short s5) {
        short s6 = s2;
        short s7 = s3;
        short s8 = s4;
        short s9 = s5;
        int n = s6 * (s7 & 1);
        int n2 = s8 * (s9 & 1);
        for (int i = 1; i < 13; ++i) {
            n ^= s6 * (s7 & 1 << i);
            n2 ^= s8 * (s9 & 1 << i);
        }
        return n ^ n2;
    }

    @Override
    protected short gf_reduce(int n) {
        int n2 = n & 0x1FFF;
        int n3 = n >>> 13;
        int n4 = n3 << 4 ^ n3 << 3 ^ n3 << 1;
        int n5 = n4 >>> 13;
        int n6 = n4 & 0x1FFF;
        int n7 = n5 << 4 ^ n5 << 3 ^ n5 << 1;
        return (short)(n2 ^ n3 ^ n5 ^ n6 ^ n7);
    }

    @Override
    protected short gf_sq(short s2) {
        int n = Interleave.expand16to32(s2);
        return this.gf_reduce(n);
    }

    @Override
    protected int gf_sq_ext(short s2) {
        return Interleave.expand16to32(s2);
    }

    private short gf_sq2(short s2) {
        int n = Interleave.expand16to32(s2);
        s2 = this.gf_reduce(n);
        int n2 = Interleave.expand16to32(s2);
        return this.gf_reduce(n2);
    }

    private short gf_sqmul(short s2, short s3) {
        long l = s2;
        long l2 = s3;
        long l3 = (l2 << 6) * (l & 0x40L);
        l ^= l << 7;
        l3 ^= (l2 << 0) * (l & 0x4001L);
        l3 ^= (l2 << 1) * (l & 0x8002L);
        l3 ^= (l2 << 2) * (l & 0x10004L);
        l3 ^= (l2 << 3) * (l & 0x20008L);
        l3 ^= (l2 << 4) * (l & 0x40010L);
        long l4 = (l3 ^= (l2 << 5) * (l & 0x80020L)) & 0x1FFC000000L;
        return this.gf_reduce((int)(l3 ^= l4 >>> 18 ^ l4 >>> 20 ^ l4 >>> 24 ^ l4 >>> 26) & 0x3FFFFFF);
    }

    private short gf_sq2mul(short s2, short s3) {
        long l = s2;
        long l2 = s3;
        long l3 = (l2 << 18) * (l & 0x40L);
        l ^= l << 21;
        l3 ^= (l2 << 0) * (l & 0x10000001L);
        l3 ^= (l2 << 3) * (l & 0x20000002L);
        l3 ^= (l2 << 6) * (l & 0x40000004L);
        l3 ^= (l2 << 9) * (l & 0x80000008L);
        l3 ^= (l2 << 12) * (l & 0x100000010L);
        long l4 = (l3 ^= (l2 << 15) * (l & 0x200000020L)) & 0x1FFFF80000000000L;
        l3 ^= l4 >>> 18 ^ l4 >>> 20 ^ l4 >>> 24 ^ l4 >>> 26;
        l4 = l3 & 0x7FFFC000000L;
        return this.gf_reduce((int)(l3 ^= l4 >>> 18 ^ l4 >>> 20 ^ l4 >>> 24 ^ l4 >>> 26) & 0x3FFFFFF);
    }
}

