/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.fasterxml.jackson.datatype.guava.deser;

import com.databricks.internal.fasterxml.jackson.core.JsonParser;
import com.databricks.internal.fasterxml.jackson.core.JsonToken;
import com.databricks.internal.fasterxml.jackson.databind.DeserializationConfig;
import com.databricks.internal.fasterxml.jackson.databind.DeserializationContext;
import com.databricks.internal.fasterxml.jackson.databind.JavaType;
import com.databricks.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.databricks.internal.fasterxml.jackson.databind.deser.NullValueProvider;
import com.databricks.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.databricks.internal.fasterxml.jackson.databind.util.AccessPattern;
import com.databricks.internal.fasterxml.jackson.datatype.guava.deser.GuavaCollectionDeserializer;
import com.databricks.internal.google.common.collect.ImmutableCollection;
import java.io.IOException;

abstract class GuavaImmutableCollectionDeserializer<T extends ImmutableCollection<Object>>
extends GuavaCollectionDeserializer<T> {
    private static final long serialVersionUID = 1L;

    GuavaImmutableCollectionDeserializer(JavaType selfType, JsonDeserializer<?> deser, TypeDeserializer typeDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    protected abstract ImmutableCollection.Builder<Object> createBuilder();

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public T getEmptyValue(DeserializationContext ctxt) {
        return (T)((ImmutableCollection)this._createEmpty(ctxt));
    }

    @Override
    protected T _deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        ImmutableCollection.Builder<Object> builder = this.createBuilder();
        while ((t2 = p.nextToken()) != JsonToken.END_ARRAY) {
            Object value;
            if (t2 == JsonToken.VALUE_NULL) {
                if (this._skipNullValues) continue;
                value = this._resolveNullToValue(ctxt);
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
            }
            builder.add(value);
        }
        ImmutableCollection<Object> collection = builder.build();
        return (T)collection;
    }

    protected Object _resolveNullToValue(DeserializationContext ctxt) throws IOException {
        Object value = this._nullProvider.getNullValue(ctxt);
        return value;
    }
}

