/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlayng;

import com.databricks.internal.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.databricks.internal.jts.algorithm.locate.PointOnGeometryLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Geometry;

class InputGeometry {
    private Geometry[] geom = new Geometry[2];
    private PointOnGeometryLocator ptLocatorA;
    private PointOnGeometryLocator ptLocatorB;
    private boolean[] isCollapsed = new boolean[2];

    public InputGeometry(Geometry geomA, Geometry geomB) {
        this.geom = new Geometry[]{geomA, geomB};
    }

    public boolean isSingle() {
        return this.geom[1] == null;
    }

    public int getDimension(int index) {
        if (this.geom[index] == null) {
            return -1;
        }
        return this.geom[index].getDimension();
    }

    public Geometry getGeometry(int geomIndex) {
        return this.geom[geomIndex];
    }

    public Envelope getEnvelope(int geomIndex) {
        return this.geom[geomIndex].getEnvelopeInternal();
    }

    public boolean isEmpty(int geomIndex) {
        return this.geom[geomIndex].isEmpty();
    }

    public boolean isArea(int geomIndex) {
        return this.geom[geomIndex] != null && this.geom[geomIndex].getDimension() == 2;
    }

    public int getAreaIndex() {
        if (this.getDimension(0) == 2) {
            return 0;
        }
        if (this.getDimension(1) == 2) {
            return 1;
        }
        return -1;
    }

    public boolean isLine(int geomIndex) {
        return this.getDimension(geomIndex) == 1;
    }

    public boolean isAllPoints() {
        return this.getDimension(0) == 0 && this.geom[1] != null && this.getDimension(1) == 0;
    }

    public boolean hasPoints() {
        return this.getDimension(0) == 0 || this.getDimension(1) == 0;
    }

    public boolean hasEdges(int geomIndex) {
        return this.geom[geomIndex] != null && this.geom[geomIndex].getDimension() > 0;
    }

    public int locatePointInArea(int geomIndex, Coordinate pt) {
        if (this.isCollapsed[geomIndex]) {
            return 2;
        }
        if (this.getGeometry(geomIndex).isEmpty() || this.isCollapsed[geomIndex]) {
            return 2;
        }
        PointOnGeometryLocator ptLocator = this.getLocator(geomIndex);
        return ptLocator.locate(pt);
    }

    private PointOnGeometryLocator getLocator(int geomIndex) {
        if (geomIndex == 0) {
            if (this.ptLocatorA == null) {
                this.ptLocatorA = new IndexedPointInAreaLocator(this.getGeometry(geomIndex));
            }
            return this.ptLocatorA;
        }
        if (this.ptLocatorB == null) {
            this.ptLocatorB = new IndexedPointInAreaLocator(this.getGeometry(geomIndex));
        }
        return this.ptLocatorB;
    }

    public void setCollapsed(int geomIndex, boolean isGeomCollapsed) {
        this.isCollapsed[geomIndex] = isGeomCollapsed;
    }
}

