/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.triangulate.polygon;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.util.PolygonExtracter;
import com.databricks.internal.jts.triangulate.polygon.PolygonEarClipper;
import com.databricks.internal.jts.triangulate.polygon.PolygonHoleJoiner;
import com.databricks.internal.jts.triangulate.tri.Tri;
import java.util.ArrayList;
import java.util.List;

public class PolygonTriangulator {
    private final GeometryFactory geomFact;
    private final Geometry inputGeom;
    private List<Tri> triList;

    public static Geometry triangulate(Geometry geom) {
        PolygonTriangulator triangulator = new PolygonTriangulator(geom);
        return triangulator.getResult();
    }

    public PolygonTriangulator(Geometry inputGeom) {
        this.geomFact = inputGeom.getFactory();
        this.inputGeom = inputGeom;
    }

    public Geometry getResult() {
        this.compute();
        return Tri.toGeometry(this.triList, this.geomFact);
    }

    public List<Tri> getTriangles() {
        this.compute();
        return this.triList;
    }

    private void compute() {
        List polys = PolygonExtracter.getPolygons(this.inputGeom);
        this.triList = new ArrayList<Tri>();
        for (Polygon poly : polys) {
            if (poly.isEmpty()) continue;
            List<Tri> polyTriList = this.triangulatePolygon(poly);
            this.triList.addAll(polyTriList);
        }
    }

    private List<Tri> triangulatePolygon(Polygon poly) {
        Coordinate[] polyShell = PolygonHoleJoiner.join(poly);
        List<Tri> triList = PolygonEarClipper.triangulate(polyShell);
        return triList;
    }
}

