/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.billing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.billing.BudgetsService;
import com.databricks.internal.sdk.service.billing.CreateBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.CreateBudgetConfigurationResponse;
import com.databricks.internal.sdk.service.billing.DeleteBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.GetBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.GetBudgetConfigurationResponse;
import com.databricks.internal.sdk.service.billing.ListBudgetConfigurationsRequest;
import com.databricks.internal.sdk.service.billing.ListBudgetConfigurationsResponse;
import com.databricks.internal.sdk.service.billing.UpdateBudgetConfigurationRequest;
import com.databricks.internal.sdk.service.billing.UpdateBudgetConfigurationResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class BudgetsImpl
implements BudgetsService {
    private final ApiClient apiClient;

    public BudgetsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateBudgetConfigurationResponse create(CreateBudgetConfigurationRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budgets", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateBudgetConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteBudgetConfigurationRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budgets/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetBudgetConfigurationResponse get(GetBudgetConfigurationRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budgets/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetBudgetConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListBudgetConfigurationsResponse list(ListBudgetConfigurationsRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budgets", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListBudgetConfigurationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateBudgetConfigurationResponse update(UpdateBudgetConfigurationRequest request) {
        String path = String.format("/api/2.1/accounts/%s/budgets/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateBudgetConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

