/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.AccountUser;
import com.databricks.internal.sdk.service.iam.AccountUsersV2Impl;
import com.databricks.internal.sdk.service.iam.AccountUsersV2Service;
import com.databricks.internal.sdk.service.iam.CreateAccountUserRequest;
import com.databricks.internal.sdk.service.iam.DeleteAccountUserRequest;
import com.databricks.internal.sdk.service.iam.GetAccountUserRequest;
import com.databricks.internal.sdk.service.iam.ListAccountUsersRequest;
import com.databricks.internal.sdk.service.iam.ListAccountUsersResponse;
import com.databricks.internal.sdk.service.iam.PatchAccountUserRequest;
import com.databricks.internal.sdk.service.iam.UpdateAccountUserRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class AccountUsersV2API {
    private static final Logger LOG = LoggerFactory.getLogger(AccountUsersV2API.class);
    private final AccountUsersV2Service impl;

    public AccountUsersV2API(ApiClient apiClient) {
        this.impl = new AccountUsersV2Impl(apiClient);
    }

    public AccountUsersV2API(AccountUsersV2Service mock) {
        this.impl = mock;
    }

    public AccountUser create(CreateAccountUserRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountUserRequest().setId(id));
    }

    public void delete(DeleteAccountUserRequest request) {
        this.impl.delete(request);
    }

    public AccountUser get(String id) {
        return this.get(new GetAccountUserRequest().setId(id));
    }

    public AccountUser get(GetAccountUserRequest request) {
        return this.impl.get(request);
    }

    public Iterable<AccountUser> list(ListAccountUsersRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator(request, this.impl::list, ListAccountUsersResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        });
    }

    public void patch(PatchAccountUserRequest request) {
        this.impl.patch(request);
    }

    public void update(UpdateAccountUserRequest request) {
        this.impl.update(request);
    }

    public AccountUsersV2Service impl() {
        return this.impl;
    }
}

