/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.impl.ComplexDataTypeParser;
import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.arrow.ArrowResultChunkIterator;
import com.databricks.jdbc.api.impl.arrow.ChunkProvider;
import com.databricks.jdbc.api.impl.arrow.InlineChunkProvider;
import com.databricks.jdbc.api.impl.arrow.RemoteChunkProvider;
import com.databricks.jdbc.api.impl.arrow.SeaChunkLinkFetcher;
import com.databricks.jdbc.api.impl.arrow.StreamingChunkProvider;
import com.databricks.jdbc.api.impl.arrow.ThriftChunkLinkFetcher;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TColumnDesc;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetResultSetMetadataResp;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowResultLink;
import com.databricks.jdbc.model.core.ChunkLinkFetchResult;
import com.databricks.jdbc.model.core.ColumnInfo;
import com.databricks.jdbc.model.core.ColumnInfoTypeName;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrowStreamResult
implements IExecutionResult {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ArrowStreamResult.class);
    private final ChunkProvider chunkProvider;
    private long currentRowIndex = -1L;
    private boolean isClosed;
    private ArrowResultChunkIterator chunkIterator;
    private List<ColumnInfo> columnInfos;
    private final IDatabricksSession session;

    public ArrowStreamResult(ResultManifest resultManifest, ResultData resultData, StatementId statementId, IDatabricksSession session) throws DatabricksSQLException {
        this(resultManifest, resultData, statementId, session, DatabricksHttpClientFactory.getInstance().getClient(session.getConnectionContext()));
    }

    @VisibleForTesting
    ArrowStreamResult(ResultManifest resultManifest, ResultData resultData, StatementId statementId, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        boolean isInlineArrow;
        this.session = session;
        boolean bl = isInlineArrow = resultData.getAttachment() != null;
        if (isInlineArrow) {
            LOGGER.debug("Creating ArrowStreamResult with inline attachment for statementId: {}", statementId.toSQLExecStatementId());
            this.chunkProvider = new InlineChunkProvider(resultData, resultManifest);
        } else {
            LOGGER.debug("Creating ArrowStreamResult with remote links for statementId: {}", statementId.toSQLExecStatementId());
            this.chunkProvider = ArrowStreamResult.createRemoteChunkProvider(statementId, resultManifest, resultData, session, httpClient);
        }
        this.columnInfos = resultManifest.getSchema().getColumnCount() == 0L ? new ArrayList<ColumnInfo>() : new ArrayList<ColumnInfo>(resultManifest.getSchema().getColumns());
    }

    private static ChunkProvider createRemoteChunkProvider(StatementId statementId, ResultManifest resultManifest, ResultData resultData, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        IDatabricksConnectionContext connectionContext = session.getConnectionContext();
        if (connectionContext.isStreamingChunkProviderEnabled()) {
            LOGGER.info("Using StreamingChunkProvider for statementId: {}", statementId.toSQLExecStatementId());
            SeaChunkLinkFetcher linkFetcher = new SeaChunkLinkFetcher(session, statementId);
            CompressionCodec compressionCodec = resultManifest.getResultCompression();
            int maxChunksInMemory = connectionContext.getCloudFetchThreadPoolSize();
            int linkPrefetchWindow = connectionContext.getLinkPrefetchWindow();
            int chunkReadyTimeoutSeconds = connectionContext.getChunkReadyTimeoutSeconds();
            double cloudFetchSpeedThreshold = connectionContext.getCloudFetchSpeedThreshold();
            ChunkLinkFetchResult initialLinks = ArrowStreamResult.convertToChunkLinkFetchResult(resultData.getExternalLinks(), resultManifest.getTotalChunkCount());
            return new StreamingChunkProvider(linkFetcher, httpClient, compressionCodec, statementId, maxChunksInMemory, linkPrefetchWindow, chunkReadyTimeoutSeconds, cloudFetchSpeedThreshold, initialLinks);
        }
        return new RemoteChunkProvider(statementId, resultManifest, resultData, session, httpClient, connectionContext.getCloudFetchThreadPoolSize());
    }

    public ArrowStreamResult(TFetchResultsResp resultsResp, boolean isInlineArrow, IDatabricksStatementInternal parentStatementId, IDatabricksSession session) throws DatabricksSQLException {
        this(resultsResp, isInlineArrow, parentStatementId, session, DatabricksHttpClientFactory.getInstance().getClient(session.getConnectionContext()));
    }

    @VisibleForTesting
    ArrowStreamResult(TFetchResultsResp resultsResp, boolean isInlineArrow, IDatabricksStatementInternal parentStatement, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        this.session = session;
        this.setColumnInfo(resultsResp.getResultSetMetadata());
        this.chunkProvider = isInlineArrow ? new InlineChunkProvider(resultsResp, parentStatement, session) : ArrowStreamResult.createThriftRemoteChunkProvider(resultsResp, parentStatement, session, httpClient);
    }

    private static ChunkProvider createThriftRemoteChunkProvider(TFetchResultsResp resultsResp, IDatabricksStatementInternal parentStatement, IDatabricksSession session, IDatabricksHttpClient httpClient) throws DatabricksSQLException {
        IDatabricksConnectionContext connectionContext = session.getConnectionContext();
        CompressionCodec compressionCodec = CompressionCodec.getCompressionMapping(resultsResp.getResultSetMetadata());
        if (connectionContext.isStreamingChunkProviderEnabled()) {
            StatementId statementId = parentStatement.getStatementId();
            LOGGER.info("Using StreamingChunkProvider for Thrift statementId: {}", statementId);
            ThriftChunkLinkFetcher linkFetcher = new ThriftChunkLinkFetcher(session, statementId);
            int maxChunksInMemory = connectionContext.getCloudFetchThreadPoolSize();
            int linkPrefetchWindow = connectionContext.getLinkPrefetchWindow();
            int chunkReadyTimeoutSeconds = connectionContext.getChunkReadyTimeoutSeconds();
            double cloudFetchSpeedThreshold = connectionContext.getCloudFetchSpeedThreshold();
            ChunkLinkFetchResult initialLinks = ArrowStreamResult.convertThriftLinksToChunkLinkFetchResult(resultsResp);
            return new StreamingChunkProvider(linkFetcher, httpClient, compressionCodec, statementId, maxChunksInMemory, linkPrefetchWindow, chunkReadyTimeoutSeconds, cloudFetchSpeedThreshold, initialLinks);
        }
        return new RemoteChunkProvider(parentStatement, resultsResp, session, httpClient, connectionContext.getCloudFetchThreadPoolSize(), compressionCodec);
    }

    public List<String> getArrowMetadata() throws DatabricksSQLException {
        if (this.chunkProvider == null || this.chunkProvider.getChunk() == null) {
            return null;
        }
        return this.chunkProvider.getChunk().getArrowMetadata();
    }

    @Override
    public Object getObject(int columnIndex) throws DatabricksSQLException {
        ColumnInfoTypeName requiredType = this.columnInfos.get(columnIndex).getTypeName();
        String arrowMetadata = this.chunkIterator.getType(columnIndex);
        if (arrowMetadata == null) {
            arrowMetadata = this.columnInfos.get(columnIndex).getTypeText();
        }
        boolean isComplexDatatypeSupportEnabled = this.session.getConnectionContext().isComplexDatatypeSupportEnabled();
        boolean isGeoSpatialSupportEnabled = this.session.getConnectionContext().isGeoSpatialSupportEnabled();
        if (!isGeoSpatialSupportEnabled && ArrowStreamResult.isGeospatialType(requiredType)) {
            LOGGER.debug("Geospatial support is disabled, converting {} to STRING", new Object[]{requiredType});
            Object result = this.chunkIterator.getColumnObjectAtCurrentRow(columnIndex, ColumnInfoTypeName.STRING, "STRING", this.columnInfos.get(columnIndex));
            if (result == null) {
                return null;
            }
            return result;
        }
        if (!isComplexDatatypeSupportEnabled && ArrowStreamResult.isComplexType(requiredType)) {
            LOGGER.debug("Complex datatype support is disabled, converting complex type to STRING");
            Object result = this.chunkIterator.getColumnObjectAtCurrentRow(columnIndex, ColumnInfoTypeName.STRING, "STRING", this.columnInfos.get(columnIndex));
            if (result == null) {
                return null;
            }
            ComplexDataTypeParser parser = new ComplexDataTypeParser();
            return parser.formatComplexTypeString(result.toString(), requiredType.name(), arrowMetadata);
        }
        return this.chunkIterator.getColumnObjectAtCurrentRow(columnIndex, requiredType, arrowMetadata, this.columnInfos.get(columnIndex));
    }

    @VisibleForTesting
    public static boolean isComplexType(ColumnInfoTypeName type) {
        return type == ColumnInfoTypeName.ARRAY || type == ColumnInfoTypeName.MAP || type == ColumnInfoTypeName.STRUCT || type == ColumnInfoTypeName.GEOMETRY || type == ColumnInfoTypeName.GEOGRAPHY;
    }

    @VisibleForTesting
    public static boolean isGeospatialType(ColumnInfoTypeName type) {
        return type == ColumnInfoTypeName.GEOMETRY || type == ColumnInfoTypeName.GEOGRAPHY;
    }

    @Override
    public long getCurrentRow() {
        return this.currentRowIndex;
    }

    @Override
    public boolean next() throws DatabricksSQLException {
        if (!this.hasNext()) {
            return false;
        }
        ++this.currentRowIndex;
        if (this.chunkIterator == null || !this.chunkIterator.hasNextRow()) {
            this.chunkProvider.next();
            this.chunkIterator = this.chunkProvider.getChunk().getChunkIterator();
        }
        return this.chunkIterator.nextRow();
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        if (this.chunkIterator != null && this.chunkIterator.hasNextRow()) {
            return true;
        }
        return this.chunkProvider.hasNextChunk();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.chunkProvider.close();
    }

    @Override
    public long getRowCount() {
        return this.chunkProvider.getRowCount();
    }

    @Override
    public long getChunkCount() {
        return this.chunkProvider.getChunkCount();
    }

    private void setColumnInfo(TGetResultSetMetadataResp resultManifest) {
        this.columnInfos = new ArrayList<ColumnInfo>();
        if (resultManifest.getSchema() == null) {
            return;
        }
        for (TColumnDesc tColumnDesc : resultManifest.getSchema().getColumns()) {
            this.columnInfos.add(DatabricksThriftUtil.getColumnInfoFromTColumnDesc(tColumnDesc));
        }
    }

    private static ChunkLinkFetchResult convertToChunkLinkFetchResult(Collection<ExternalLink> externalLinks, Long totalChunkCount) {
        if (externalLinks == null || externalLinks.isEmpty()) {
            if (totalChunkCount != null && totalChunkCount == 0L) {
                LOGGER.debug("Total chunk count is zero, returning end of stream");
                return ChunkLinkFetchResult.endOfStream();
            }
            return null;
        }
        List<Object> linkList = externalLinks instanceof List ? (List<Object>)externalLinks : new ArrayList<ExternalLink>(externalLinks);
        ExternalLink lastLink = (ExternalLink)linkList.get(linkList.size() - 1);
        boolean hasMore = lastLink.getNextChunkIndex() != null;
        long nextFetchIndex = hasMore ? lastLink.getNextChunkIndex() : -1L;
        long nextRowOffset = lastLink.getRowOffset() + lastLink.getRowCount();
        LOGGER.debug("Converting ExternalLinks to ChunkLinkFetchResult: linkCount={}, hasMore={}, nextFetchIndex={}, nextRowOffset={}", linkList.size(), hasMore, nextFetchIndex, nextRowOffset);
        return ChunkLinkFetchResult.of((List<ExternalLink>)linkList, hasMore, nextFetchIndex, nextRowOffset);
    }

    private static ChunkLinkFetchResult convertThriftLinksToChunkLinkFetchResult(TFetchResultsResp resultsResp) {
        List<TSparkArrowResultLink> resultLinks = resultsResp.getResults().getResultLinks();
        if (resultLinks == null || resultLinks.isEmpty()) {
            if (!resultsResp.hasMoreRows) {
                LOGGER.debug("No result links and hasMoreRows is false, returning end of stream");
                return ChunkLinkFetchResult.endOfStream();
            }
            return null;
        }
        ArrayList<ExternalLink> chunkLinks = new ArrayList<ExternalLink>();
        int lastIndex = resultLinks.size() - 1;
        boolean hasMoreRows = resultsResp.hasMoreRows;
        for (int linkIndex = 0; linkIndex < resultLinks.size(); ++linkIndex) {
            TSparkArrowResultLink thriftLink = resultLinks.get(linkIndex);
            ExternalLink externalLink = DatabricksThriftUtil.createExternalLink(thriftLink, linkIndex);
            if (linkIndex == lastIndex) {
                if (hasMoreRows) {
                    externalLink.setNextChunkIndex((long)linkIndex + 1L);
                }
            } else {
                externalLink.setNextChunkIndex((long)linkIndex + 1L);
            }
            chunkLinks.add(externalLink);
        }
        TSparkArrowResultLink lastThriftLink = resultLinks.get(lastIndex);
        long nextFetchIndex = hasMoreRows ? (long)(lastIndex + 1) : -1L;
        long nextRowOffset = lastThriftLink.getStartRowOffset() + lastThriftLink.getRowCount();
        return ChunkLinkFetchResult.of(chunkLinks, hasMoreRows, nextFetchIndex, nextRowOffset);
    }
}

