/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public enum ChunkStatus {
    PENDING,
    URL_FETCHED,
    DOWNLOAD_IN_PROGRESS,
    DOWNLOAD_SUCCEEDED,
    PROCESSING_SUCCEEDED,
    DOWNLOAD_FAILED,
    PROCESSING_FAILED,
    CANCELLED,
    CHUNK_RELEASED,
    DOWNLOAD_RETRY;

    private static final Map<ChunkStatus, Set<ChunkStatus>> VALID_TRANSITIONS;

    public Set<ChunkStatus> getValidTransitions() {
        return VALID_TRANSITIONS.getOrDefault((Object)this, Collections.emptySet());
    }

    public boolean canTransitionTo(ChunkStatus targetStatus) {
        return this.getValidTransitions().contains((Object)targetStatus);
    }

    static {
        VALID_TRANSITIONS = new EnumMap<ChunkStatus, Set<ChunkStatus>>(ChunkStatus.class);
        VALID_TRANSITIONS.put(PENDING, Set.of(URL_FETCHED, CHUNK_RELEASED, DOWNLOAD_FAILED));
        VALID_TRANSITIONS.put(URL_FETCHED, Set.of(DOWNLOAD_SUCCEEDED, DOWNLOAD_FAILED, CANCELLED, CHUNK_RELEASED));
        VALID_TRANSITIONS.put(DOWNLOAD_SUCCEEDED, Set.of(PROCESSING_SUCCEEDED, PROCESSING_FAILED, CHUNK_RELEASED));
        VALID_TRANSITIONS.put(PROCESSING_SUCCEEDED, Set.of(CHUNK_RELEASED));
        VALID_TRANSITIONS.put(DOWNLOAD_FAILED, Set.of(DOWNLOAD_RETRY, CHUNK_RELEASED));
        VALID_TRANSITIONS.put(PROCESSING_FAILED, Set.of(CHUNK_RELEASED));
        VALID_TRANSITIONS.put(CANCELLED, Set.of(CHUNK_RELEASED));
        VALID_TRANSITIONS.put(CHUNK_RELEASED, Collections.emptySet());
        VALID_TRANSITIONS.put(DOWNLOAD_RETRY, Set.of(URL_FETCHED, DOWNLOAD_SUCCEEDED, DOWNLOAD_FAILED, CHUNK_RELEASED));
    }
}

