/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.MultiLineString;
import com.databricks.internal.jts.geom.MultiPoint;
import com.databricks.internal.jts.geom.MultiPolygon;
import com.databricks.internal.jts.geom.Point;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.io.Ordinate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;

public class JTSOGCWKBWriter {
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_DOUBLE = 8;
    private static final int POINT_TYPE = 1;
    private static final int LINESTRING_TYPE = 2;
    private static final int POLYGON_TYPE = 3;
    private static final int MULTIPOINT_TYPE = 4;
    private static final int MULTILINESTRING_TYPE = 5;
    private static final int MULTIPOLYGON_TYPE = 6;
    private static final int GEOMETRYCOLLECTION_TYPE = 7;
    private static final int Z_TYPE_OFFSET = 1000;
    private static final int M_TYPE_OFFSET = 2000;
    private static final int ZM_TYPE_OFFSET = 3000;
    private EnumSet<Ordinate> outputOrdinates;
    private ByteOrder byteOrder;
    private int outputDimension;

    public JTSOGCWKBWriter(EnumSet<Ordinate> outputOrdinates, ByteOrder byteOrder) {
        this.outputOrdinates = outputOrdinates;
        this.byteOrder = byteOrder;
        this.outputDimension = 2;
        if (this.hasZ()) {
            ++this.outputDimension;
        }
        if (this.hasM()) {
            ++this.outputDimension;
        }
    }

    public byte[] write(Geometry geom) {
        byte[] wkb = new byte[this.numBytes(geom)];
        ByteBuffer buffer = ByteBuffer.wrap(wkb).order(this.byteOrder);
        this.write(buffer, 0, geom);
        return wkb;
    }

    private int numBytes(Geometry geom) {
        if (geom instanceof Point) {
            return this.numBytes((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.numBytes((LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.numBytes((Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.numBytes((GeometryCollection)geom);
        }
        throw new IllegalArgumentException("numBytes: Unknown or unsupported type");
    }

    private int numBytes(Point point) {
        return 5 + this.outputDimension * 8;
    }

    private int numBytes(LineString lineString) {
        return 9 + lineString.getNumPoints() * this.outputDimension * 8;
    }

    private int numBytes(Polygon polygon) {
        return 9 + polygon.getNumPoints() * this.outputDimension * 8 + this.numRings(polygon) * 4;
    }

    private int numBytes(GeometryCollection collection) {
        int numBytes = 9;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            numBytes += this.numBytes(collection.getGeometryN(i));
        }
        return numBytes;
    }

    private int numRings(Polygon polygon) {
        return polygon.isEmpty() ? 0 : polygon.getNumInteriorRing() + 1;
    }

    public int write(ByteBuffer buffer, int pos, Geometry geom) {
        if (geom instanceof Point) {
            return this.write(buffer, pos, (Point)geom);
        }
        if (geom instanceof LineString) {
            return this.write(buffer, pos, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.write(buffer, pos, (Polygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return this.write(buffer, pos, (GeometryCollection)geom);
        }
        throw new IllegalArgumentException("write: Unknown or unsupported type");
    }

    private int write(ByteBuffer buffer, int pos, Point point) {
        buffer.put(pos, (byte)(this.isLittleEndian() ? 1 : 0));
        buffer.putInt(++pos, this.fromBaseType(1));
        return this.writeCoords(buffer, pos + 4, point.getCoordinate());
    }

    private int write(ByteBuffer buffer, int pos, LineString lineString) {
        buffer.put(pos, (byte)(this.isLittleEndian() ? 1 : 0));
        buffer.putInt(++pos, this.fromBaseType(2));
        buffer.putInt(pos += 4, lineString.getNumPoints());
        pos += 4;
        for (int i = 0; i < lineString.getNumPoints(); ++i) {
            pos = this.writeCoords(buffer, pos, lineString.getCoordinateN(i));
        }
        return pos;
    }

    private int write(ByteBuffer buffer, int pos, Polygon polygon) {
        buffer.put(pos, (byte)(this.isLittleEndian() ? 1 : 0));
        buffer.putInt(++pos, this.fromBaseType(3));
        int numRings = this.numRings(polygon);
        buffer.putInt(pos += 4, numRings);
        pos += 4;
        if (numRings > 0) {
            LinearRing outer = polygon.getExteriorRing();
            buffer.putInt(pos, outer.getNumPoints());
            pos += 4;
            for (int i = 0; i < outer.getNumPoints(); ++i) {
                pos = this.writeCoords(buffer, pos, outer.getCoordinateN(i));
            }
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing inner = polygon.getInteriorRingN(i);
            buffer.putInt(pos, inner.getNumPoints());
            pos += 4;
            for (int j = 0; j < inner.getNumPoints(); ++j) {
                pos = this.writeCoords(buffer, pos, inner.getCoordinateN(j));
            }
        }
        return pos;
    }

    private int write(ByteBuffer buffer, int pos, GeometryCollection collection) {
        buffer.put(pos, (byte)(this.isLittleEndian() ? 1 : 0));
        ++pos;
        if (collection instanceof MultiPoint) {
            buffer.putInt(pos, this.fromBaseType(4));
        } else if (collection instanceof MultiLineString) {
            buffer.putInt(pos, this.fromBaseType(5));
        } else if (collection instanceof MultiPolygon) {
            buffer.putInt(pos, this.fromBaseType(6));
        } else {
            buffer.putInt(pos, this.fromBaseType(7));
        }
        buffer.putInt(pos += 4, collection.getNumGeometries());
        pos += 4;
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            pos = this.write(buffer, pos, collection.getGeometryN(i));
        }
        return pos;
    }

    private int writeCoords(ByteBuffer buffer, int pos, Coordinate coords) {
        if (coords == null) {
            buffer.putDouble(pos, Double.NaN);
            buffer.putDouble(pos += 8, Double.NaN);
            if (this.hasZ()) {
                buffer.putDouble(pos += 8, Double.NaN);
            }
            if (this.hasM()) {
                buffer.putDouble(pos += 8, Double.NaN);
            }
            return pos + 8;
        }
        buffer.putDouble(pos, coords.getX());
        buffer.putDouble(pos += 8, coords.getY());
        if (this.hasZ()) {
            buffer.putDouble(pos += 8, coords.getZ());
        }
        if (this.hasM()) {
            buffer.putDouble(pos += 8, coords.getM());
        }
        return pos + 8;
    }

    private boolean isLittleEndian() {
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN;
    }

    private boolean hasZ() {
        return this.outputOrdinates.contains((Object)Ordinate.Z);
    }

    private boolean hasM() {
        return this.outputOrdinates.contains((Object)Ordinate.M);
    }

    private int fromBaseType(int baseType) {
        boolean hasZ = this.hasZ();
        boolean hasM = this.hasM();
        if (hasZ && hasM) {
            return baseType + 3000;
        }
        if (hasZ) {
            return baseType + 1000;
        }
        if (hasM) {
            return baseType + 2000;
        }
        return baseType;
    }
}

