/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.impl.ColumnarRowView;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TColumn;
import com.databricks.jdbc.model.client.thrift.generated.TColumnDesc;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetOperationStatusResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetResultSetMetadataResp;
import com.databricks.jdbc.model.client.thrift.generated.THandleIdentifier;
import com.databricks.jdbc.model.client.thrift.generated.TNamespace;
import com.databricks.jdbc.model.client.thrift.generated.TOperationHandle;
import com.databricks.jdbc.model.client.thrift.generated.TOperationType;
import com.databricks.jdbc.model.client.thrift.generated.TPrimitiveTypeEntry;
import com.databricks.jdbc.model.client.thrift.generated.TRowSet;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowResultLink;
import com.databricks.jdbc.model.client.thrift.generated.TSparkDirectResults;
import com.databricks.jdbc.model.client.thrift.generated.TStatus;
import com.databricks.jdbc.model.client.thrift.generated.TStatusCode;
import com.databricks.jdbc.model.client.thrift.generated.TTypeDesc;
import com.databricks.jdbc.model.client.thrift.generated.TTypeId;
import com.databricks.jdbc.model.client.thrift.generated.TTypeQualifiers;
import com.databricks.jdbc.model.core.ColumnInfo;
import com.databricks.jdbc.model.core.ColumnInfoTypeName;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.StatementStatus;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DatabricksThriftUtil {
    private static final Map<TTypeId, ColumnInfoTypeName> T_TYPE_ID_COLUMN_INFO_TYPE_NAME_MAP = Map.ofEntries(Map.entry(TTypeId.BOOLEAN_TYPE, ColumnInfoTypeName.BOOLEAN), Map.entry(TTypeId.TINYINT_TYPE, ColumnInfoTypeName.BYTE), Map.entry(TTypeId.SMALLINT_TYPE, ColumnInfoTypeName.SHORT), Map.entry(TTypeId.INT_TYPE, ColumnInfoTypeName.INT), Map.entry(TTypeId.BIGINT_TYPE, ColumnInfoTypeName.LONG), Map.entry(TTypeId.FLOAT_TYPE, ColumnInfoTypeName.FLOAT), Map.entry(TTypeId.DOUBLE_TYPE, ColumnInfoTypeName.DOUBLE), Map.entry(TTypeId.STRING_TYPE, ColumnInfoTypeName.STRING), Map.entry(TTypeId.VARCHAR_TYPE, ColumnInfoTypeName.STRING), Map.entry(TTypeId.TIMESTAMP_TYPE, ColumnInfoTypeName.TIMESTAMP), Map.entry(TTypeId.BINARY_TYPE, ColumnInfoTypeName.BINARY), Map.entry(TTypeId.DECIMAL_TYPE, ColumnInfoTypeName.DECIMAL), Map.entry(TTypeId.DATE_TYPE, ColumnInfoTypeName.DATE), Map.entry(TTypeId.CHAR_TYPE, ColumnInfoTypeName.CHAR), Map.entry(TTypeId.INTERVAL_YEAR_MONTH_TYPE, ColumnInfoTypeName.INTERVAL), Map.entry(TTypeId.INTERVAL_DAY_TIME_TYPE, ColumnInfoTypeName.INTERVAL), Map.entry(TTypeId.ARRAY_TYPE, ColumnInfoTypeName.ARRAY), Map.entry(TTypeId.MAP_TYPE, ColumnInfoTypeName.MAP), Map.entry(TTypeId.NULL_TYPE, ColumnInfoTypeName.STRING), Map.entry(TTypeId.STRUCT_TYPE, ColumnInfoTypeName.STRUCT));
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksThriftUtil.class);
    private static final List<TStatusCode> SUCCESS_STATUS_LIST = List.of(TStatusCode.SUCCESS_STATUS, TStatusCode.SUCCESS_WITH_INFO_STATUS);

    public static TNamespace getNamespace(String catalog, String schema) {
        return new TNamespace().setCatalogName(catalog).setSchemaName(schema);
    }

    public static String byteBufferToString(ByteBuffer buffer) {
        ByteBuffer newBuffer = buffer.duplicate();
        if (newBuffer.remaining() >= 16) {
            long mostSigBits = newBuffer.getLong();
            long leastSigBits = newBuffer.getLong();
            return new UUID(mostSigBits, leastSigBits).toString();
        }
        long sigBits = newBuffer.getLong();
        return new UUID(sigBits, sigBits).toString();
    }

    public static ExternalLink createExternalLink(TSparkArrowResultLink chunkInfo, long chunkIndex) {
        return new ExternalLink().setExternalLink(chunkInfo.getFileLink()).setChunkIndex(chunkIndex).setExpiration(Instant.ofEpochMilli(chunkInfo.getExpiryTime()).toString()).setRowOffset(chunkInfo.getStartRowOffset()).setByteCount(chunkInfo.getBytesNum()).setRowCount(chunkInfo.getRowCount());
    }

    public static void verifySuccessStatus(TStatus status, String errorContext) throws DatabricksHttpException {
        DatabricksThriftUtil.verifySuccessStatus(status, errorContext, null);
    }

    public static void verifySuccessStatus(TStatus status, String errorContext, String statementId) throws DatabricksHttpException {
        if (!SUCCESS_STATUS_LIST.contains(status.getStatusCode())) {
            String errorMessage = statementId != null ? String.format("Error thrift response received [%s] for statementId [%s]", errorContext, statementId) : String.format("Error thrift response received [%s]", errorContext);
            LOGGER.error(errorMessage);
            throw new DatabricksHttpException(errorMessage, status.getSqlState());
        }
    }

    public static int getColumnCount(TGetResultSetMetadataResp resultManifest) {
        if (resultManifest == null || resultManifest.getSchema() == null) {
            return 0;
        }
        return resultManifest.getSchema().getColumnsSize();
    }

    public static List<List<Object>> extractRowsFromColumnar(TRowSet rowSet) throws DatabricksSQLException {
        if (rowSet == null || rowSet.getColumns() == null || rowSet.getColumns().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        ArrayList columnIterators = new ArrayList();
        for (TColumn column : rowSet.getColumns()) {
            columnIterators.add(DatabricksThriftUtil.getColumnValues(column).iterator());
        }
        while (((Iterator)columnIterators.get(0)).hasNext()) {
            ArrayList row = new ArrayList();
            columnIterators.forEach(columnIterator -> row.add(columnIterator.next()));
            rows.add(row);
        }
        return rows;
    }

    public static ColumnarRowView createColumnarView(TRowSet rowSet) throws DatabricksSQLException {
        return new ColumnarRowView(rowSet);
    }

    public static StatementStatus getStatementStatus(TGetOperationStatusResp resp) {
        StatementState state = null;
        switch (resp.getOperationState()) {
            case INITIALIZED_STATE: 
            case PENDING_STATE: {
                state = StatementState.PENDING;
                break;
            }
            case RUNNING_STATE: {
                state = StatementState.RUNNING;
                break;
            }
            case FINISHED_STATE: {
                state = StatementState.SUCCEEDED;
                break;
            }
            case ERROR_STATE: 
            case TIMEDOUT_STATE: {
                state = StatementState.FAILED;
                break;
            }
            case CLOSED_STATE: {
                state = StatementState.CLOSED;
                break;
            }
            case CANCELED_STATE: {
                state = StatementState.CANCELED;
                break;
            }
            case UKNOWN_STATE: {
                state = StatementState.FAILED;
            }
        }
        return new StatementStatus().setState(state);
    }

    public static StatementStatus getAsyncStatus(TStatus status) {
        StatementStatus statementStatus = new StatementStatus();
        StatementState state = null;
        switch (status.getStatusCode()) {
            case SUCCESS_STATUS: 
            case SUCCESS_WITH_INFO_STATUS: 
            case STILL_EXECUTING_STATUS: {
                state = StatementState.RUNNING;
                break;
            }
            case INVALID_HANDLE_STATUS: 
            case ERROR_STATUS: {
                state = StatementState.FAILED;
                break;
            }
            default: {
                state = StatementState.FAILED;
            }
        }
        return new StatementStatus().setState(state);
    }

    public static String getTypeTextFromTypeDesc(TTypeDesc typeDesc) {
        TPrimitiveTypeEntry primitiveTypeEntry = DatabricksTypeUtil.getTPrimitiveTypeOrDefault(typeDesc);
        return primitiveTypeEntry.getType().name().replace("_TYPE", "");
    }

    public static ColumnInfo getColumnInfoFromTColumnDesc(TColumnDesc columnDesc) {
        TPrimitiveTypeEntry primitiveTypeEntry = DatabricksTypeUtil.getTPrimitiveTypeOrDefault(columnDesc.getTypeDesc());
        ColumnInfoTypeName columnInfoTypeName = T_TYPE_ID_COLUMN_INFO_TYPE_NAME_MAP.get(primitiveTypeEntry.getType());
        ColumnInfo columnInfo = new ColumnInfo().setName(columnDesc.getColumnName()).setPosition(Long.valueOf(columnDesc.getPosition())).setTypeName(columnInfoTypeName).setTypeText(DatabricksThriftUtil.getTypeTextFromTypeDesc(columnDesc.getTypeDesc()));
        if (primitiveTypeEntry.isSetTypeQualifiers()) {
            TTypeQualifiers typeQualifiers = primitiveTypeEntry.getTypeQualifiers();
            String scaleQualifierKey = "scale";
            String precisionQualifierKey = "precision";
            if (typeQualifiers.getQualifiers().get(scaleQualifierKey) != null) {
                columnInfo.setTypeScale(Long.valueOf(typeQualifiers.getQualifiers().get(scaleQualifierKey).getI32Value()));
            }
            if (typeQualifiers.getQualifiers().get(precisionQualifierKey) != null) {
                columnInfo.setTypePrecision(Long.valueOf(typeQualifiers.getQualifiers().get(precisionQualifierKey).getI32Value()));
            }
        }
        return columnInfo;
    }

    private static List<?> getColumnValues(TColumn column) throws DatabricksSQLException {
        if (column.isSetBinaryVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getBinaryVal().getValues(), column.getBinaryVal().getNulls());
        }
        if (column.isSetBoolVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getBoolVal().getValues(), column.getBoolVal().getNulls());
        }
        if (column.isSetByteVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getByteVal().getValues(), column.getByteVal().getNulls());
        }
        if (column.isSetDoubleVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getDoubleVal().getValues(), column.getDoubleVal().getNulls());
        }
        if (column.isSetI16Val()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getI16Val().getValues(), column.getI16Val().getNulls());
        }
        if (column.isSetI32Val()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getI32Val().getValues(), column.getI32Val().getNulls());
        }
        if (column.isSetI64Val()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getI64Val().getValues(), column.getI64Val().getNulls());
        }
        if (column.isSetDoubleVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getDoubleVal().getValues(), column.getDoubleVal().getNulls());
        }
        if (column.isSetStringVal()) {
            return DatabricksThriftUtil.getColumnValuesWithNulls(column.getStringVal().getValues(), column.getStringVal().getNulls());
        }
        throw new DatabricksSQLException("Unsupported column type: " + String.valueOf(column), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    private static <T> List<T> getColumnValuesWithNulls(List<T> values, byte[] nulls) {
        ArrayList<T> result = new ArrayList<T>();
        if (nulls != null) {
            BitSet nullBits = BitSet.valueOf(nulls);
            for (int i = 0; i < values.size(); ++i) {
                if (nullBits.get(i)) {
                    result.add(null);
                    continue;
                }
                result.add(values.get(i));
            }
        } else {
            result.addAll(values);
        }
        return result;
    }

    public static List<List<Object>> convertColumnarToRowBased(TFetchResultsResp resultsResp, IDatabricksStatementInternal parentStatement, IDatabricksSession session) throws DatabricksSQLException {
        int statementMaxRows = parentStatement != null ? parentStatement.getMaxRows() : 0;
        boolean hasRowLimit = statementMaxRows > 0;
        List<List<Object>> rows = DatabricksThriftUtil.extractRowsFromColumnar(resultsResp.getResults());
        while (resultsResp.hasMoreRows) {
            resultsResp = session.getDatabricksClient().getMoreResults(parentStatement);
            rows.addAll(DatabricksThriftUtil.extractRowsFromColumnar(resultsResp.getResults()));
            if (!hasRowLimit || rows.size() < statementMaxRows) continue;
        }
        if (hasRowLimit && rows.size() > statementMaxRows) {
            rows = rows.subList(0, statementMaxRows);
        }
        return rows;
    }

    public static TOperationHandle getOperationHandle(StatementId statementId) {
        THandleIdentifier identifier = statementId.toOperationIdentifier();
        LOGGER.debug("getOperationHandle for statementId {}", DatabricksThriftUtil.byteBufferToString(identifier.guid));
        return new TOperationHandle().setOperationId(identifier).setOperationType(TOperationType.UNKNOWN);
    }

    public static long getRowCount(TRowSet resultData) throws DatabricksSQLException {
        if (resultData == null) {
            return 0L;
        }
        if (resultData.isSetColumns()) {
            List<TColumn> columns = resultData.getColumns();
            return columns == null || columns.isEmpty() ? 0L : (long)DatabricksThriftUtil.getColumnValues(columns.get(0)).size();
        }
        if (resultData.isSetResultLinks()) {
            return resultData.getResultLinks().stream().mapToLong(link -> link.isSetRowCount() ? link.getRowCount() : 0L).sum();
        }
        if (resultData.isSetArrowBatches()) {
            return resultData.getArrowBatches().stream().mapToLong(batch -> batch.isSetRowCount() ? batch.getRowCount() : 0L).sum();
        }
        return 0L;
    }

    public static void checkDirectResultsForErrorStatus(TSparkDirectResults directResults, String context, String statementId) throws DatabricksHttpException {
        if (directResults.isSetOperationStatus()) {
            LOGGER.debug("direct result operation status being verified for success response for statementId {}", statementId);
            DatabricksThriftUtil.verifySuccessStatus(directResults.getOperationStatus().getStatus(), context, statementId);
        }
        if (directResults.isSetResultSetMetadata()) {
            LOGGER.debug("direct results metadata being verified for success response for statementId {}", statementId);
            DatabricksThriftUtil.verifySuccessStatus(directResults.getResultSetMetadata().getStatus(), context, statementId);
        }
        if (directResults.isSetCloseOperation()) {
            LOGGER.debug("direct results close operation verified for success response for statementId {}", statementId);
            DatabricksThriftUtil.verifySuccessStatus(directResults.getCloseOperation().getStatus(), context, statementId);
        }
        if (directResults.isSetResultSet()) {
            LOGGER.debug("direct result set being verified for success response for statementId {}", statementId);
            DatabricksThriftUtil.verifySuccessStatus(directResults.getResultSet().getStatus(), context, statementId);
        }
    }
}

