/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class JdbcThreadUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> List<R> parallelMap(Collection<T> items, IDatabricksConnectionContext connectionContext, int maxThreads, int timeoutSeconds, Function<T, R> task, ExecutorService executor) throws SQLException {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        boolean createdExecutor = false;
        ExecutorService executorToUse = executor;
        if (executorToUse == null) {
            int threadCount = Math.min(items.size(), maxThreads);
            executorToUse = Executors.newFixedThreadPool(threadCount);
            createdExecutor = true;
        }
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (T item : items) {
                futures.add(executorToUse.submit(() -> {
                    DatabricksThreadContextHolder.setConnectionContext(connectionContext);
                    try {
                        Object r = task.apply(item);
                        return r;
                    }
                    finally {
                        DatabricksThreadContextHolder.clearConnectionContext();
                    }
                }));
            }
            ArrayList results = new ArrayList(items.size());
            for (Future future : futures) {
                try {
                    results.add(future.get(timeoutSeconds, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new DatabricksSQLException("Parallel execution interrupted", (Throwable)e, DatabricksDriverErrorCode.THREAD_INTERRUPTED_ERROR);
                }
                catch (ExecutionException e) {
                    SQLException sqlEx = JdbcThreadUtils.findSQLExceptionInCauseChain(e);
                    if (sqlEx != null) {
                        throw sqlEx;
                    }
                    throw new DatabricksSQLException("Error in parallel execution", (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
                }
                catch (TimeoutException e) {
                    throw new DatabricksSQLException("Parallel execution timed out after " + timeoutSeconds + " seconds", (Throwable)e, DatabricksDriverErrorCode.OPERATION_TIMEOUT_ERROR);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            if (createdExecutor && executorToUse != null) {
                executorToUse.shutdownNow();
            }
        }
    }

    public static <T, R> List<R> parallelFlatMap(Collection<T> items, IDatabricksConnectionContext connectionContext, int maxThreads, int timeoutSeconds, Function<T, Collection<R>> task, ExecutorService executor) throws SQLException {
        List<Collection<R>> collections = JdbcThreadUtils.parallelMap(items, connectionContext, maxThreads, timeoutSeconds, task, executor);
        ArrayList<R> allResults = new ArrayList<R>();
        for (Collection<R> collection : collections) {
            if (collection == null) continue;
            allResults.addAll(collection);
        }
        return allResults;
    }

    private static SQLException findSQLExceptionInCauseChain(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        return JdbcThreadUtils.findSQLExceptionInCauseChain(throwable.getCause());
    }
}

