/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.jdbc.common.util.WildcardUtil;
import java.util.Optional;

public class ProcessNameUtil {
    private static final String FALL_BACK_PROCESS_NAME = "UnknownJavaProcess";

    public static String getProcessName() {
        try {
            String processName = ProcessNameUtil.getProcessNameFromHandle();
            if (!WildcardUtil.isNullOrEmpty(processName)) {
                return processName;
            }
            return FALL_BACK_PROCESS_NAME;
        }
        catch (Exception e) {
            return FALL_BACK_PROCESS_NAME;
        }
    }

    public static String getProcessNameFromHandle() {
        try {
            String command = System.getProperty("sun.java.command");
            if (!WildcardUtil.isNullOrEmpty(command)) {
                String[] parts = command.split(" ");
                return ProcessNameUtil.getSimpleClassName(parts[0]);
            }
            Optional<String> cmdOptional = ProcessHandle.current().info().command();
            if (cmdOptional.isPresent()) {
                String cmd = cmdOptional.get();
                String filename = cmd.substring(Math.max(cmd.lastIndexOf(47), cmd.lastIndexOf(92)) + 1);
                int dotIndex = filename.lastIndexOf(46);
                if (dotIndex > 0) {
                    filename = filename.substring(0, dotIndex);
                }
                return filename;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getSimpleClassName(String fqcn) {
        if (WildcardUtil.isNullOrEmpty(fqcn)) {
            return null;
        }
        int lastDot = fqcn.lastIndexOf(46);
        return lastDot >= 0 ? fqcn.substring(lastDot + 1) : fqcn;
    }
}

