/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StringUtil {
    public static String convertJdbcEscapeSequences(String sql) {
        sql = sql.replaceAll("\\{d '([0-9]{4}-[0-9]{2}-[0-9]{2})'\\}", "DATE '$1'").replaceAll("\\{t '([0-9]{2}:[0-9]{2}:[0-9]{2})'\\}", "TIME '$1'").replaceAll("\\{ts '([0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?)'\\}", "TIMESTAMP '$1'").replaceAll("\\{fn ([^}]*)\\}", "$1").replaceAll("\\{oj ([^}]*)\\}", "$1").replaceAll("\\{call ([^}]*)\\}", "CALL $1");
        return sql;
    }

    public static String escapeStringLiteral(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("'", "''");
    }

    public static boolean checkPrefixMatch(String prefix, String fileName, boolean caseSensitive) {
        return prefix.isEmpty() || fileName.regionMatches(!caseSensitive, 0, prefix, 0, prefix.length());
    }

    public static List<String> split(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return List.of(value.split(","));
    }

    public static String getFolderNameFromPath(String path) {
        if (path == null) {
            return "";
        }
        int lastSlashIndex = path.lastIndexOf("/");
        return lastSlashIndex >= 0 ? path.substring(0, lastSlashIndex) : "";
    }

    public static String getBaseNameFromPath(String path) {
        if (path == null) {
            return "";
        }
        int lastSlashIndex = path.lastIndexOf("/");
        return lastSlashIndex >= 0 ? path.substring(lastSlashIndex + 1) : path;
    }

    public static String getVolumePath(String catalog, String schema, String volume) {
        return StringUtil.escapeStringLiteral(String.format("/Volumes/%s/%s/%s/", catalog, schema, volume));
    }

    public static String removeRedundantEscapeClause(String sql) {
        if (sql == null) {
            return null;
        }
        return sql.replaceAll("(?i)\\s+ESCAPE\\s+['\"]['\"](?=\\s|;|$|\\)|,)", "");
    }

    public static Set<Integer> parseIntegerSet(String input) {
        if (input.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(input.split(",")).map(String::trim).filter(s2 -> !s2.isEmpty()).filter(num -> num.matches("\\d+")).map(Integer::parseInt).collect(Collectors.toSet());
    }
}

