/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.exception;

import com.databricks.jdbc.common.TelemetryLogLevel;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.TelemetryHelper;

public class DatabricksDriverException
extends RuntimeException {
    public DatabricksDriverException(String reason, DatabricksDriverErrorCode internalError) {
        this(reason, internalError.name());
    }

    public DatabricksDriverException(String reason, Throwable cause, DatabricksDriverErrorCode internalError) {
        this(reason, cause, internalError.toString());
    }

    public DatabricksDriverException(String reason, Throwable cause, String sqlState) {
        super(reason, cause);
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), sqlState, reason, TelemetryLogLevel.ERROR);
    }

    public DatabricksDriverException(String reason, String sqlState) {
        super(reason);
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), sqlState, reason, TelemetryLogLevel.ERROR);
    }
}

