/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.exception;

import com.databricks.jdbc.common.TelemetryLogLevel;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.exception.DatabricksVendorCode;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.sql.SQLException;

public class DatabricksSQLException
extends SQLException {
    public DatabricksSQLException(String reason, DatabricksDriverErrorCode internalError) {
        this(reason, internalError.name());
    }

    public DatabricksSQLException(String reason, DatabricksDriverErrorCode internalError, boolean silentExceptions) {
        this(reason, internalError.name(), silentExceptions);
    }

    public DatabricksSQLException(String reason, Throwable cause, DatabricksDriverErrorCode internalError) {
        this(reason, cause, internalError.toString());
    }

    public DatabricksSQLException(String reason, Throwable cause, String sqlState) {
        this(reason, sqlState, DatabricksVendorCode.getVendorCode(cause), cause);
    }

    public DatabricksSQLException(String reason, Throwable cause, String statementId, Long chunkIndex, String sqlState) {
        super(reason, sqlState, DatabricksVendorCode.getVendorCode(cause), cause);
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), DatabricksDriverErrorCode.CONNECTION_ERROR.name(), reason, statementId, chunkIndex, TelemetryLogLevel.ERROR);
    }

    public DatabricksSQLException(String reason, String sqlState) {
        this(reason, sqlState, false);
    }

    public DatabricksSQLException(String reason, String sqlState, boolean silentExceptions) {
        this(reason, sqlState, DatabricksVendorCode.getVendorCode(reason), silentExceptions);
    }

    public DatabricksSQLException(String reason, String sqlState, DatabricksDriverErrorCode internalError) {
        super(reason, sqlState);
        this.logTelemetryEvent(sqlState, reason, false);
    }

    public DatabricksSQLException(String reason, String sqlState, int vendorCode) {
        this(reason, sqlState, vendorCode, false);
    }

    public DatabricksSQLException(String reason, String sqlState, int vendorCode, boolean silentExceptions) {
        super(reason, sqlState, vendorCode);
        this.logTelemetryEvent(sqlState, reason, silentExceptions);
    }

    public DatabricksSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
        this.logTelemetryEvent(sqlState, reason, false);
    }

    private void logTelemetryEvent(String sqlState, String reason, boolean silentExceptions) {
        if (!silentExceptions) {
            TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), sqlState, reason, TelemetryLogLevel.ERROR);
        } else {
            TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), sqlState, reason, TelemetryLogLevel.WARN);
        }
    }
}

