/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.apache.arrow.util.VisibleForTesting;
import com.databricks.internal.apache.http.client.HttpResponseException;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreaker;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksTelemetryException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;

public class CircuitBreakerManager {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(CircuitBreakerManager.class);
    private static final CircuitBreakerManager INSTANCE = new CircuitBreakerManager();
    private final Map<String, CircuitBreaker> breakerPerHost = new ConcurrentHashMap<String, CircuitBreaker>();
    private final CircuitBreakerConfig config = CircuitBreakerConfig.custom().failureRateThreshold(50.0f).minimumNumberOfCalls(20).slidingWindowSize(30).waitDurationInOpenState(Duration.ofSeconds(30L)).permittedNumberOfCallsInHalfOpenState(3).slidingWindowType(CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).recordExceptions(ConnectException.class, SocketTimeoutException.class, NoRouteToHostException.class, UnknownHostException.class, RejectedExecutionException.class, OutOfMemoryError.class, HttpResponseException.class, DatabricksTelemetryException.class).ignoreExceptions(DatabricksParsingException.class, IllegalArgumentException.class, NullPointerException.class).build();

    public static CircuitBreakerManager getInstance() {
        return INSTANCE;
    }

    private CircuitBreakerManager() {
        LOGGER.debug("CircuitBreakerManager initialized");
    }

    public CircuitBreaker getCircuitBreaker(String host) {
        return this.breakerPerHost.computeIfAbsent(host, h2 -> {
            CircuitBreaker breaker = CircuitBreaker.of("telemetry-client-" + h2, this.config);
            breaker.getEventPublisher().onStateTransition(event -> LOGGER.debug("CircuitBreaker for host [{}] transitioned from {} to {}", new Object[]{h2, event.getStateTransition().getFromState(), event.getStateTransition().getToState()}));
            return breaker;
        });
    }

    @VisibleForTesting
    void resetCircuitBreaker(String host) {
        this.breakerPerHost.remove(host);
    }
}

