/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry.latency;

import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.telemetry.latency.DatabricksMetricsTimed;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class DatabricksMetricsTimedProcessor {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksMetricsTimedProcessor.class);

    public static <T> T createProxy(T obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == null) {
            LOGGER.trace("Cannot create proxy for null object, skipping latency processing.");
            return obj;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            LOGGER.trace("Proxy creation skipped \u2014 target class {} does not implement any interfaces, skipping latency processing.", obj.getClass().getName());
            return obj;
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, new TimedInvocationHandler<T>(obj));
    }

    private static class TimedInvocationHandler<T>
    implements InvocationHandler {
        private final T target;

        public TimedInvocationHandler(T target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (proxy == null || method == null) {
                return method != null ? method.invoke(this.target, args) : null;
            }
            try {
                if (method.isAnnotationPresent(DatabricksMetricsTimed.class)) {
                    String methodName = method.getName() != null ? method.getName() : "unknown";
                    long startTime = System.nanoTime();
                    Object result = method.invoke(this.target, args);
                    long executionTimeNanos = System.nanoTime() - startTime;
                    long executionTimeMillis = executionTimeNanos / 1000000L;
                    String argsStr = args != null ? String.join((CharSequence)", ", (CharSequence[])Arrays.stream(args).map(arg -> arg != null ? arg.toString() : "null").toArray(String[]::new)) : "none";
                    LOGGER.debug("Method [{}] with args [{}] execution time: {}ms", methodName, argsStr, executionTimeMillis);
                    try {
                        TelemetryCollector.getInstance().recordOperationLatency(executionTimeMillis, methodName);
                    }
                    catch (Exception e) {
                        LOGGER.trace("Failed to export latency metrics for method {}: {}", methodName, e.getMessage());
                    }
                    return result;
                }
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

