/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client;

import com.dataiku.dss.shadeliba2a.io.a2a.client.ClientEvent;
import com.dataiku.dss.shadeliba2a.io.a2a.client.transport.spi.interceptors.ClientCallContext;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientException;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AgentCard;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.GetTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ListTaskPushNotificationConfigParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Message;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.PushNotificationConfig;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Task;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskIdParams;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskPushNotificationConfig;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskQueryParams;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractClient {
    private final List<BiConsumer<ClientEvent, AgentCard>> consumers;
    private final @Nullable Consumer<Throwable> streamingErrorHandler;

    public AbstractClient(List<BiConsumer<ClientEvent, AgentCard>> consumers) {
        this(consumers, null);
    }

    public AbstractClient(@NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler) {
        Assert.checkNotNullParam("consumers", consumers);
        this.consumers = consumers;
        this.streamingErrorHandler = streamingErrorHandler;
    }

    public void sendMessage(Message request) throws A2AClientException {
        this.sendMessage(request, null);
    }

    public abstract void sendMessage(Message var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void sendMessage(Message request, List<BiConsumer<ClientEvent, AgentCard>> consumers, Consumer<Throwable> streamingErrorHandler) throws A2AClientException {
        this.sendMessage(request, consumers, streamingErrorHandler, null);
    }

    public abstract void sendMessage(Message var1, List<BiConsumer<ClientEvent, AgentCard>> var2, Consumer<Throwable> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public void sendMessage(Message request, PushNotificationConfig pushNotificationConfiguration, Map<String, Object> metadata) throws A2AClientException {
        this.sendMessage(request, pushNotificationConfiguration, metadata, null);
    }

    public abstract void sendMessage(Message var1, PushNotificationConfig var2, Map<String, Object> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public Task getTask(TaskQueryParams request) throws A2AClientException {
        return this.getTask(request, null);
    }

    public abstract Task getTask(TaskQueryParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public Task cancelTask(TaskIdParams request) throws A2AClientException {
        return this.cancelTask(request, null);
    }

    public abstract Task cancelTask(TaskIdParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request) throws A2AClientException {
        return this.setTaskPushNotificationConfiguration(request, null);
    }

    public abstract TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request) throws A2AClientException {
        return this.getTaskPushNotificationConfiguration(request, null);
    }

    public abstract TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public List<TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request) throws A2AClientException {
        return this.listTaskPushNotificationConfigurations(request, null);
    }

    public abstract List<TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request) throws A2AClientException {
        this.deleteTaskPushNotificationConfigurations(request, null);
    }

    public abstract void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void resubscribe(TaskIdParams request) throws A2AClientException {
        this.resubscribe(request, null);
    }

    public abstract void resubscribe(TaskIdParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void resubscribe(TaskIdParams request, List<BiConsumer<ClientEvent, AgentCard>> consumers, Consumer<Throwable> streamingErrorHandler) throws A2AClientException {
        this.resubscribe(request, consumers, streamingErrorHandler, null);
    }

    public abstract void resubscribe(TaskIdParams var1, List<BiConsumer<ClientEvent, AgentCard>> var2, Consumer<Throwable> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public AgentCard getAgentCard() throws A2AClientException {
        return this.getAgentCard(null);
    }

    public abstract AgentCard getAgentCard(@Nullable ClientCallContext var1) throws A2AClientException;

    public abstract void close();

    void consume(ClientEvent clientEventOrMessage, AgentCard agentCard) {
        for (BiConsumer<ClientEvent, AgentCard> consumer : this.consumers) {
            consumer.accept(clientEventOrMessage, agentCard);
        }
    }

    public @Nullable Consumer<Throwable> getStreamingErrorHandler() {
        return this.streamingErrorHandler;
    }
}

